/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import de.mrjulsen.mcdragonlib.util.math.MathUtils;

public final class DLColor {
    private final int a;
    private final int r;
    private final int g;
    private final int b;
    private final boolean isDefined;
    public static final DLColor WHITE = DLColor.of(255, 255, 255);
    public static final DLColor BLACK = DLColor.of(0, 0, 0);
    public static final DLColor RED = DLColor.of(255, 0, 0);
    public static final DLColor GREEN = DLColor.of(0, 255, 0);
    public static final DLColor BLUE = DLColor.of(0, 0, 255);
    public static final DLColor YELLOW = DLColor.of(255, 255, 0);
    public static final DLColor CYAN = DLColor.of(0, 255, 255);
    public static final DLColor MAGENTA = DLColor.of(255, 0, 255);
    public static final DLColor TRANSPARENT = DLColor.of(0, 0, 0, 0);
    public static final DLColor UNDEFINED = new DLColor();

    private DLColor(int a, int r, int g, int b) {
        this.a = DLColor.clamp(a);
        this.r = DLColor.clamp(r);
        this.g = DLColor.clamp(g);
        this.b = DLColor.clamp(b);
        this.isDefined = true;
    }

    private DLColor() {
        this.a = 0;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.isDefined = false;
    }

    public static DLColor of(int r, int g, int b) {
        return new DLColor(255, r, g, b);
    }

    public static DLColor of(int a, int r, int g, int b) {
        return new DLColor(a, r, g, b);
    }

    public static DLColor of(float r, float g, float b) {
        return new DLColor(255, (int)(DLColor.clamp(r) * 255.0f + 0.5f), (int)(DLColor.clamp(g) * 255.0f + 0.5f), (int)(DLColor.clamp(b) * 255.0f + 0.5f));
    }

    public static DLColor of(float a, float r, float g, float b) {
        return new DLColor((int)(DLColor.clamp(a) * 255.0f + 0.5f), (int)(DLColor.clamp(r) * 255.0f + 0.5f), (int)(DLColor.clamp(g) * 255.0f + 0.5f), (int)(DLColor.clamp(b) * 255.0f + 0.5f));
    }

    public static DLColor fromInt(int argb) {
        return new DLColor(argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public static DLColor fromHex(String hexString) {
        int[] c = DLColor.parseHex(hexString);
        return new DLColor(c[0], c[1], c[2], c[3]);
    }

    public static DLColor fromHsv(float h, float s, float v) {
        float b;
        float g;
        float r;
        h = (h % 360.0f + 360.0f) % 360.0f;
        s = DLColor.clamp(s);
        v = DLColor.clamp(v);
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return DLColor.of(r + m, g + m, b + m);
    }

    private void checkDefined() {
        if (!this.isDefined) {
            throw new IllegalStateException("Operation cannot be performed on an UNDEFINED color.");
        }
    }

    public int getAlpha() {
        this.checkDefined();
        return this.a;
    }

    public int getRed() {
        this.checkDefined();
        return this.r;
    }

    public int getGreen() {
        this.checkDefined();
        return this.g;
    }

    public int getBlue() {
        this.checkDefined();
        return this.b;
    }

    public float getAlphaF() {
        this.checkDefined();
        return (float)this.a / 255.0f;
    }

    public float getRedF() {
        this.checkDefined();
        return (float)this.r / 255.0f;
    }

    public float getGreenF() {
        this.checkDefined();
        return (float)this.g / 255.0f;
    }

    public float getBlueF() {
        this.checkDefined();
        return (float)this.b / 255.0f;
    }

    public float getHue() {
        this.checkDefined();
        return this.getAsHSB()[0];
    }

    public float getSaturation() {
        this.checkDefined();
        return this.getAsHSB()[1];
    }

    public float getBrightness() {
        this.checkDefined();
        return this.getAsHSB()[2];
    }

    public int getHueInt() {
        this.checkDefined();
        return (int)this.getHue();
    }

    public int getSaturationInt() {
        this.checkDefined();
        return Math.round(this.getSaturation() * 100.0f);
    }

    public int getValueInt() {
        this.checkDefined();
        return Math.round(this.getBrightness() * 100.0f);
    }

    public int getAsARGB() {
        this.checkDefined();
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public String getAsHEX(boolean includeAlpha) {
        this.checkDefined();
        return includeAlpha ? String.format("#%02X%02X%02X%02X", this.a, this.r, this.g, this.b) : String.format("#%02X%02X%02X", this.r, this.g, this.b);
    }

    public float[] getAsHSB() {
        this.checkDefined();
        float r_ = this.getRedF();
        float g_ = this.getGreenF();
        float b_ = this.getBlueF();
        float cmax = Math.max(r_, Math.max(g_, b_));
        float cmin = Math.min(r_, Math.min(g_, b_));
        float delta = cmax - cmin;
        float h = 0.0f;
        if (delta != 0.0f) {
            h = cmax == r_ ? 60.0f * ((g_ - b_) / delta % 6.0f) : (cmax == g_ ? 60.0f * ((b_ - r_) / delta + 2.0f) : 60.0f * ((r_ - g_) / delta + 4.0f));
        }
        h = (h + 360.0f) % 360.0f;
        float s = cmax == 0.0f ? 0.0f : delta / cmax;
        return new float[]{h, s, cmax};
    }

    public boolean isUndefined() {
        return !this.isDefined;
    }

    public boolean hasTransparency() {
        return this.getAlphaF() < 1.0f;
    }

    public boolean isTransparent() {
        return this.getAlphaF() <= 0.0f;
    }

    public DLColor lighten(float amount) {
        this.checkDefined();
        return DLColor.blend(this, WHITE, amount);
    }

    public DLColor darken(float amount) {
        this.checkDefined();
        return DLColor.blend(this, BLACK, amount);
    }

    public DLColor invert() {
        this.checkDefined();
        return new DLColor(this.a, 255 - this.r, 255 - this.g, 255 - this.b);
    }

    public DLColor grayscale() {
        this.checkDefined();
        int gray = (int)Math.round((double)this.r * 0.299 + (double)this.g * 0.587 + (double)this.b * 0.114);
        return new DLColor(this.a, gray, gray, gray);
    }

    public DLColor saturate(float amount) {
        this.checkDefined();
        float[] hsv = this.getAsHSB();
        hsv[1] = DLColor.clamp(hsv[1] + amount);
        return DLColor.fromHsv(hsv[0], hsv[1], hsv[2]).withAlpha(this.a);
    }

    public DLColor rotateHue(float degrees) {
        this.checkDefined();
        float[] hsv = this.getAsHSB();
        hsv[0] = (hsv[0] + degrees) % 360.0f;
        return DLColor.fromHsv(hsv[0], hsv[1], hsv[2]).withAlpha(this.a);
    }

    public DLColor withAlpha(int newAlpha) {
        this.checkDefined();
        return new DLColor(newAlpha, this.r, this.g, this.b);
    }

    public DLColor swapChannels(ColorChannel c1, ColorChannel c2) {
        this.checkDefined();
        int red = this.r;
        int green = this.g;
        int blue = this.b;
        int val1 = this.getChannelValue(c1);
        int val2 = this.getChannelValue(c2);
        red = this.setChannelValue(ColorChannel.R, c1, val2, this.setChannelValue(ColorChannel.R, c2, val1, red));
        green = this.setChannelValue(ColorChannel.G, c1, val2, this.setChannelValue(ColorChannel.G, c2, val1, green));
        blue = this.setChannelValue(ColorChannel.B, c1, val2, this.setChannelValue(ColorChannel.B, c2, val1, blue));
        return new DLColor(this.a, red, green, blue);
    }

    public float getLuminance() {
        this.checkDefined();
        return 0.299f * this.getRedF() + 0.587f * this.getGreenF() + 0.114f * this.getBlueF();
    }

    public boolean isLight(float threshold) {
        this.checkDefined();
        return this.getLuminance() > threshold;
    }

    public static DLColor blend(DLColor color1, DLColor color2, float factor) {
        color1.checkDefined();
        color2.checkDefined();
        factor = DLColor.clamp(factor);
        float t_ = 1.0f - factor;
        int a = (int)((float)color1.a * t_ + (float)color2.a * factor);
        int r = (int)((float)color1.r * t_ + (float)color2.r * factor);
        int g = (int)((float)color1.g * t_ + (float)color2.g * factor);
        int b = (int)((float)color1.b * t_ + (float)color2.b * factor);
        return new DLColor(a, r, g, b);
    }

    public static DLColor combine(DLColor c1, DLColor c2, CombineMode mode) {
        float resG;
        float resR;
        c1.checkDefined();
        c2.checkDefined();
        float r1 = c1.getRedF();
        float g1 = c1.getGreenF();
        float b1 = c1.getBlueF();
        float r2 = c2.getRedF();
        float g2 = c2.getGreenF();
        float b2 = c2.getBlueF();
        return DLColor.of((float)(c1.a + c2.a) / 510.0f, resR, resG, switch (mode.ordinal()) {
            case 0 -> {
                resR = r1 + r2;
                resG = g1 + g2;
                yield b1 + b2;
            }
            case 1 -> {
                resR = r1 - r2;
                resG = g1 - g2;
                yield b1 - b2;
            }
            case 2 -> {
                resR = MathUtils.clamp(r1 * r2, 0.0f, 255.0f);
                resG = MathUtils.clamp(g1 * g2, 0.0f, 255.0f);
                yield MathUtils.clamp(b1 * b2, 0.0f, 255.0f);
            }
            case 3 -> {
                resR = 1.0f - (1.0f - r1) * (1.0f - r2);
                resG = 1.0f - (1.0f - g1) * (1.0f - g2);
                yield 1.0f - (1.0f - b1) * (1.0f - b2);
            }
            case 4 -> {
                resR = 1.0f - (1.0f - r1) * (1.0f - r2);
                resG = 1.0f - (1.0f - g1) * (1.0f - g2);
                yield 1.0f - (1.0f - b1) * (1.0f - b2);
            }
            case 5 -> {
                resR = (double)r1 < 0.5 ? 2.0f * r1 * r2 : 1.0f - 2.0f * (1.0f - r1) * (1.0f - r2);
                resG = (double)g1 < 0.5 ? 2.0f * g1 * g2 : 1.0f - 2.0f * (1.0f - g1) * (1.0f - g2);
                yield (double)b1 < 0.5 ? 2.0f * b1 * b2 : 1.0f - 2.0f * (1.0f - b1) * (1.0f - b2);
            }
            case 6 -> {
                resR = Math.abs(r1 - r2);
                resG = Math.abs(g1 - g2);
                yield Math.abs(b1 - b2);
            }
            default -> throw new UnsupportedOperationException("CombineMode " + String.valueOf((Object)mode) + " not implemented.");
        });
    }

    public static DLColor alphaBlend(DLColor foreground, DLColor background) {
        foreground.checkDefined();
        background.checkDefined();
        float fgA = foreground.getAlphaF();
        float bgA = background.getAlphaF();
        float outA = fgA + bgA * (1.0f - fgA);
        if (outA == 0.0f) {
            return TRANSPARENT;
        }
        float r = (foreground.getRedF() * fgA + background.getRedF() * bgA * (1.0f - fgA)) / outA;
        float g = (foreground.getGreenF() * fgA + background.getGreenF() * bgA * (1.0f - fgA)) / outA;
        float b = (foreground.getBlueF() * fgA + background.getBlueF() * bgA * (1.0f - fgA)) / outA;
        return DLColor.of(outA, r, g, b);
    }

    public static DLColor mixTint(DLColor colorA, DLColor colorB) {
        float alphaA = colorA.getAlphaF();
        float alphaB = colorB.getAlphaF();
        float[] A = new float[]{colorA.getRedF(), colorA.getGreenF(), colorA.getBlueF()};
        float[] B = new float[]{colorB.getRedF(), colorB.getGreenF(), colorB.getBlueF()};
        float w = 1.0f;
        for (int i = 0; i < 3; ++i) {
            float maxVal = Math.max(A[i], B[i]);
            float minVal = Math.min(maxVal, 1.0f);
            w *= minVal;
        }
        float[] result = new float[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = Math.max(A[i], B[i]) * (1.0f - w) + Math.min(A[i], B[i]) * w;
        }
        return DLColor.of((alphaA + alphaB) / 2.0f, result[0], result[1], result[2]);
    }

    public static DLColor pickBasedOnBrightness(DLColor base, DLColor lightColor, DLColor darkColor, float threshold) {
        base.checkDefined();
        return base.isLight(threshold) ? darkColor : lightColor;
    }

    public static double distance(DLColor c1, DLColor c2) {
        c1.checkDefined();
        c2.checkDefined();
        int dr = c1.r - c2.r;
        int dg = c1.g - c2.g;
        int db = c1.b - c2.b;
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    private int getChannelValue(ColorChannel channel) {
        this.checkDefined();
        switch (channel.ordinal()) {
            case 0: {
                return this.r;
            }
            case 1: {
                return this.g;
            }
            case 2: {
                return this.b;
            }
        }
        throw new IllegalArgumentException();
    }

    private int setChannelValue(ColorChannel target, ColorChannel source, int value, int current) {
        return target == source ? value : current;
    }

    private static int clamp(int v) {
        return Math.max(0, Math.min(255, v));
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static int[] parseHex(String hex) {
        int b;
        int g;
        int r;
        int a;
        block6: {
            String clean = hex.startsWith("#") ? hex.substring(1) : hex;
            a = 255;
            try {
                if (clean.length() == 3) {
                    r = Integer.parseInt(clean.substring(0, 1) + clean.substring(0, 1), 16);
                    g = Integer.parseInt(clean.substring(1, 2) + clean.substring(1, 2), 16);
                    b = Integer.parseInt(clean.substring(2, 3) + clean.substring(2, 3), 16);
                    break block6;
                }
                if (clean.length() == 4) {
                    a = Integer.parseInt(clean.substring(0, 1) + clean.substring(0, 1), 16);
                    r = Integer.parseInt(clean.substring(1, 2) + clean.substring(1, 2), 16);
                    g = Integer.parseInt(clean.substring(2, 3) + clean.substring(2, 3), 16);
                    b = Integer.parseInt(clean.substring(3, 4) + clean.substring(3, 4), 16);
                    break block6;
                }
                if (clean.length() == 6) {
                    r = Integer.parseInt(clean.substring(0, 2), 16);
                    g = Integer.parseInt(clean.substring(2, 4), 16);
                    b = Integer.parseInt(clean.substring(4, 6), 16);
                    break block6;
                }
                if (clean.length() == 8) {
                    a = Integer.parseInt(clean.substring(0, 2), 16);
                    r = Integer.parseInt(clean.substring(2, 4), 16);
                    g = Integer.parseInt(clean.substring(4, 6), 16);
                    b = Integer.parseInt(clean.substring(6, 8), 16);
                    break block6;
                }
                throw new IllegalArgumentException();
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid HEX color string: " + hex, e);
            }
        }
        return new int[]{a, r, g, b};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DLColor c = (DLColor)o;
        if (!this.isDefined || !c.isDefined) {
            return this.isDefined == c.isDefined;
        }
        return this.a == c.a && this.r == c.r && this.g == c.g && this.b == c.b;
    }

    public int hashCode() {
        return this.isDefined ? this.getAsARGB() : -1;
    }

    public String toString() {
        return this.isDefined ? String.format("DLColor[A=%d, R=%d, G=%d, B=%d]", this.a, this.r, this.g, this.b) : "DLColor[UNDEFINED]";
    }

    public static enum ColorChannel {
        R,
        G,
        B;

    }

    public static enum CombineMode {
        ADD,
        SUBTRACT,
        MULTIPLY,
        NEGATIVE_MULTIPLY,
        SCREEN,
        OVERLAY,
        DIFFERENCE;

    }
}

