/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class DLStatistics {
    public static final DLStatistics EMPTY = new DLStatistics("", List.of());
    private final String name;
    private final Map<Group, List<Stat>> stats;

    public DLStatistics(String name, List<Stat> stats) {
        this.stats = new LinkedHashMap<Group, List<Stat>>();
        for (Stat stat : stats) {
            this.stats.computeIfAbsent(stat.group(), g -> new ArrayList()).add(stat);
        }
        this.name = name;
    }

    private DLStatistics(String name, Map<Group, List<Stat>> stats) {
        this.name = name;
        this.stats = stats;
    }

    public String getName() {
        return this.name;
    }

    public String print(boolean withStatNames) {
        return this.name + ": " + this.stats.entrySet().stream().map(entry -> {
            String formattedValues;
            String groupName = ((Group)entry.getKey()).name();
            List values = (List)entry.getValue();
            if (values.size() == 1) {
                Stat x2 = (Stat)values.get(0);
                Object str = String.valueOf(x2.value());
                if (withStatNames) {
                    str = x2.name() + ": " + (String)str;
                }
                formattedValues = str;
            } else {
                formattedValues = values.stream().map(x -> {
                    Object str = String.valueOf(x.value());
                    if (withStatNames) {
                        str = x.name() + ": " + (String)str;
                    }
                    return str;
                }).collect(Collectors.joining(", ", "[", "]"));
            }
            return groupName + ": " + formattedValues;
        }).collect(Collectors.joining(", "));
    }

    @SafeVarargs
    public static DLStatistics merge(String name, BiFunction<Object, Object, Object> mergeFunction, DLStatistics ... statistics) {
        LinkedHashMap<Group, Map> merged = new LinkedHashMap<Group, Map>();
        for (DLStatistics statistic : statistics) {
            for (List<Stat> stat : statistic.stats.values()) {
                for (Stat s : stat) {
                    merged.computeIfAbsent(s.group(), g -> new LinkedHashMap()).merge(s.name(), s, (a, b) -> new Stat(a.group(), a.name(), mergeFunction.apply(a.value(), b.value())));
                }
            }
        }
        LinkedHashMap<Group, List<Stat>> result = new LinkedHashMap<Group, List<Stat>>();
        for (Map.Entry stat : merged.entrySet()) {
            for (Stat s : ((Map)stat.getValue()).values()) {
                result.computeIfAbsent(s.group(), g -> new ArrayList()).add(s);
            }
        }
        return new DLStatistics(name, result);
    }

    public record Stat(Group group, String name, Object value) {
    }

    public record Group(String id, String name) {
    }
}

