/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.apache.commons.codec.binary.Base64;

public final class DLUtils {
    public static ResourceLocation resourceLocation(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation resourceLocation(String path) {
        return new ResourceLocation(path);
    }

    public static void giveAdvancement(ServerPlayer player, String modid, String name, String criteriaKey) {
        Advancement adv = player.m_20194_().m_129889_().m_136041_(new ResourceLocation(modid, name));
        player.m_8960_().m_135988_(adv, criteriaKey);
    }

    public static String textureToBase64(NativeImage image) {
        try {
            return Base64.encodeBase64String((byte[])image.m_85121_());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static InputStream scaleImage(InputStream inputStream, int width, int height) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputStream);
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(originalImage, 0, 0, width, height, null);
        g2d.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledImage, "png", outputStream);
        byte[] imageBytes = outputStream.toByteArray();
        return new ByteArrayInputStream(imageBytes);
    }

    public static long encode3DCoordinates(int x, int y, int z) {
        long encodedValue = 0L;
        encodedValue |= ((long)x & 0xFFFFFFFFL) << 32;
        encodedValue |= ((long)y & 0xFFFFFFFFL) << 16;
        return encodedValue |= (long)z & 0xFFFFFFFFL;
    }

    @Deprecated
    public static int coordsToInt(byte x, byte y) {
        int coords = (x & 0xFF) << 16 | y & 0xFF;
        return coords;
    }

    @Deprecated
    public static byte[] intToCoords(int coords) {
        byte x = (byte)(coords >> 16 & 0xFF);
        byte y = (byte)(coords & 0xFF);
        return new byte[]{x, y};
    }

    public static Point3D decode3DCoordinates(long encodedValue) {
        int x = (int)(encodedValue >> 32);
        int y = (int)(encodedValue >> 16 & 0xFFFFL);
        int z = (int)(encodedValue & 0xFFFFL);
        return new Point3D(x, y, z);
    }

    public static boolean rotateBlock(Level world, BlockPos pos, Rotation rotation) {
        BlockState state = world.m_8055_(pos);
        BlockState newState = state.m_60717_(rotation);
        if (newState != state) {
            BlockPos otherPos;
            BlockState otherState;
            world.m_46597_(pos, newState);
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                BlockState nextState = newState.m_60728_(d, otherState = world.m_8055_(otherPos = pos.m_121945_(d)), (LevelAccessor)world, pos, otherPos);
                if (nextState == newState) continue;
                if (!nextState.m_60795_()) {
                    world.m_46597_(pos, nextState);
                    newState = nextState;
                    continue;
                }
                world.m_46597_(pos, state);
                return false;
            }
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                otherPos = pos.m_121945_(d);
                otherState = world.m_8055_(otherPos);
                BlockState nextOther = otherState.m_60728_(d.m_122424_(), newState, (LevelAccessor)world, otherPos, pos);
                if (nextOther == otherState) continue;
                world.m_46597_(otherPos, nextOther);
            }
            return true;
        }
        return false;
    }

    public static <T> void doIfNotNull(T obj, Consumer<T> action) {
        if (obj != null) {
            action.accept(obj);
        }
    }

    public static <T> void doIfNull(T obj, Runnable action) {
        if (obj == null) {
            action.run();
        }
    }

    public boolean isSectionInChunk(SectionPos section, ChunkPos chunk) {
        return section.m_123341_() == chunk.f_45578_ && section.m_123343_() == chunk.f_45579_;
    }

    public ChunkPos getChunkOfSection(SectionPos section) {
        return new ChunkPos(section.m_123341_(), section.m_123343_());
    }

    public static boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public record Point3D(int x, int y, int z) {
    }
}

