/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.net.URL;
import java.util.Scanner;
import java.util.UUID;

public final class MinecraftApi {
    private MinecraftApi() {
    }

    public static UUID getPlayerUUID(String playername) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playername);
            Scanner scan = new Scanner(url.openStream());
            Object str = "";
            while (scan.hasNext()) {
                str = (String)str + scan.nextLine();
            }
            scan.close();
            JsonObject player = (JsonObject)new Gson().fromJson((String)str, JsonObject.class);
            return UUID.fromString(player.get("id").getAsString());
        }
        catch (Exception e) {
            DragonLib.LOGGER.warn("Could not get UUID for player with username " + playername, (Throwable)e);
            return new UUID(0L, 0L);
        }
    }

    public static String getPlayerName(UUID uuid) {
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid));
            Scanner scan = new Scanner(url.openStream());
            Object str = "";
            while (scan.hasNext()) {
                str = (String)str + scan.nextLine();
            }
            scan.close();
            JsonObject player = (JsonObject)new Gson().fromJson((String)str, JsonObject.class);
            String username = player.get("name").getAsString();
            return username;
        }
        catch (Exception e) {
            DragonLib.LOGGER.warn("Could not get username for player with UUID " + String.valueOf(uuid), (Throwable)e);
            return "Unknown User";
        }
    }
}

