/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class NbtUtils {
    public static final String NBT_X = "X";
    public static final String NBT_Y = "Y";
    public static final String NBT_Z = "Z";

    private NbtUtils() {
    }

    private static void putIntPos(CompoundTag compound, String name, int x, int y, int z) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_X, x);
        nbt.m_128405_(NBT_Y, y);
        nbt.m_128405_(NBT_Z, z);
        compound.m_128365_(name, (Tag)nbt);
    }

    private static void putDoublePos(CompoundTag compound, String name, double x, double y, double z) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_(NBT_X, x);
        nbt.m_128347_(NBT_Y, y);
        nbt.m_128347_(NBT_Z, z);
        compound.m_128365_(name, (Tag)nbt);
    }

    public static void putNbtPos(CompoundTag compound, String name, Vec3i pos) {
        NbtUtils.putIntPos(compound, name, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void putNbtVector3i(CompoundTag compound, String name, Vector3ic pos) {
        NbtUtils.putIntPos(compound, name, pos.x(), pos.y(), pos.z());
    }

    public static void putNbtVec(CompoundTag compound, String name, Vec3 pos) {
        NbtUtils.putDoublePos(compound, name, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public static void putNbtVector3f(CompoundTag compound, String name, Vector3fc pos) {
        NbtUtils.putDoublePos(compound, name, pos.x(), pos.y(), pos.z());
    }

    public static void putNbtVector3d(CompoundTag compound, String name, Vector3dc pos) {
        NbtUtils.putDoublePos(compound, name, pos.x(), pos.y(), pos.z());
    }

    public static BlockPos getNbtBlockPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new BlockPos(nbt.m_128451_(NBT_X), nbt.m_128451_(NBT_Y), nbt.m_128451_(NBT_Z));
    }

    public static SectionPos getNbtSectionPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return SectionPos.m_123173_((int)nbt.m_128451_(NBT_X), (int)nbt.m_128451_(NBT_Y), (int)nbt.m_128451_(NBT_Z));
    }

    public static Vec3i getNbtVec3i(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vec3i(nbt.m_128451_(NBT_X), nbt.m_128451_(NBT_Y), nbt.m_128451_(NBT_Z));
    }

    public static Vector3i getNbtVector3i(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vector3i(nbt.m_128451_(NBT_X), nbt.m_128451_(NBT_Y), nbt.m_128451_(NBT_Z));
    }

    public static Vec3 getNbtVec3(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vec3(nbt.m_128459_(NBT_X), nbt.m_128459_(NBT_Y), nbt.m_128459_(NBT_Z));
    }

    public static Vector3f getNbtVector3f(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vector3f((float)nbt.m_128459_(NBT_X), (float)nbt.m_128459_(NBT_Y), (float)nbt.m_128459_(NBT_Z));
    }

    public static Vector3d getNbtVector3d(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vector3d(nbt.m_128459_(NBT_X), nbt.m_128459_(NBT_Y), nbt.m_128459_(NBT_Z));
    }

    public static ChunkPos getNbtChunkPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new ChunkPos(nbt.m_128451_(NBT_X), nbt.m_128451_(NBT_Z));
    }

    public static void putNbtChunkPos(CompoundTag compound, String name, ChunkPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_X, pos.f_45578_);
        nbt.m_128405_(NBT_Z, pos.f_45579_);
        compound.m_128365_(name, (Tag)nbt);
    }
}

