/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.Objects;

public class Pair<A, B> {
    protected A value1;
    protected B value2;

    public Pair(A value1, B value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public A getFirst() {
        return this.value1;
    }

    public B getSecond() {
        return this.value2;
    }

    protected void setFirst(A value) {
        this.value1 = value;
    }

    protected void setSecond(B value) {
        this.value2 = value;
    }

    public Pair<A, B> swap(Pair<A, B> pair) {
        return Pair.of(pair.getFirst(), pair.getSecond());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return this.getFirst().equals(other.getFirst()) && this.getSecond().equals(other.getSecond());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getFirst(), this.getSecond());
    }

    public String toString() {
        return String.format("(%s, %s)", this.getFirst(), this.getSecond());
    }

    public static class MutablePair<A, B>
    extends Pair<A, B> {
        public MutablePair(A value1, B value2) {
            super(value1, value2);
        }

        @Override
        protected void setFirst(A value) {
            super.setFirst(value);
        }

        @Override
        public void setSecond(B value) {
            super.setSecond(value);
        }
    }
}

