/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public final class TextUtils {
    public static final Component TEXT_DRAGON = TextUtils.translate("text.dragonlib.dragon");
    public static final Component TEXT_NEXT = TextUtils.translate("text.dragonlib.next");
    public static final Component TEXT_PREVIOUS = TextUtils.translate("text.dragonlib.previous");
    public static final Component TEXT_GO_BACK = TextUtils.translate("text.dragonlib.go_back");
    public static final Component TEXT_GO_FORTH = TextUtils.translate("text.dragonlib.go_forth");
    public static final Component TEXT_GO_UP = TextUtils.translate("text.dragonlib.go_down");
    public static final Component TEXT_GO_DOWN = TextUtils.translate("text.dragonlib.go_up");
    public static final Component TEXT_GO_RIGHT = TextUtils.translate("text.dragonlib.go_right");
    public static final Component TEXT_GO_LEFT = TextUtils.translate("text.dragonlib.go_left");
    public static final Component TEXT_GO_TO_TOP = TextUtils.translate("text.dragonlib.go_to_top");
    public static final Component TEXT_GO_TO_BOTTOM = TextUtils.translate("text.dragonlib.go_to_bottom");
    public static final Component TEXT_RESET_DEFAULTS = TextUtils.translate("text.dragonlib.reset_defaults");
    public static final Component TEXT_EXPAND = TextUtils.translate("text.dragonlib.expand");
    public static final Component TEXT_COLLAPSE = TextUtils.translate("text.dragonlib.collapse");
    public static final Component TEXT_COUNT = TextUtils.translate("text.dragonlib.count");
    public static final Component TEXT_TRUE = TextUtils.translate("text.dragonlib.true");
    public static final Component TEXT_FALSE = TextUtils.translate("text.dragonlib.false");
    public static final Component TEXT_CLOSE = TextUtils.translate("text.dragonlib.close");
    public static final Component TEXT_SHOW = TextUtils.translate("text.dragonlib.show");
    public static final Component TEXT_HIDE = TextUtils.translate("text.dragonlib.hide");
    public static final Component TEXT_SEARCH = TextUtils.translate("text.dragonlib.search");
    public static final Component TEXT_REFRESH = TextUtils.translate("text.dragonlib.refresh");
    public static final Component TEXT_RELOAD = TextUtils.translate("text.dragonlib.reload");
    public static final Component EMPTY = TextUtils.empty();
    private static final Component TEXT_CONCAT = TextUtils.text("     ***     ");
    public static final String ELLIPSIS_STRING = "...";
    public static final Component ELLIPSIS_COMPONENT = TextUtils.text("...");

    public static MutableComponent text(String text) {
        return Component.m_237113_((String)text);
    }

    public static MutableComponent translate(String text, Object ... args) {
        return Component.m_237110_((String)text, (Object[])args);
    }

    public static MutableComponent translate(String text) {
        return Component.m_237115_((String)text);
    }

    public static MutableComponent keybind(String key) {
        return Component.m_237117_((String)key);
    }

    public static MutableComponent empty() {
        return TextUtils.text("");
    }

    public static Component truncateWithEllipsis(Font font, Component text, int maxWidth) {
        int lineWidth = font.m_92852_((FormattedText)text);
        return lineWidth < maxWidth ? text : TextUtils.text(font.m_92854_((FormattedText)text, maxWidth - font.m_92852_((FormattedText)TextUtils.text(ELLIPSIS_STRING).m_130948_(text.m_7383_()))).getString() + ELLIPSIS_STRING).m_130948_(text.m_7383_());
    }

    public static String truncateWithEllipsis(Font font, String text, int maxWidth) {
        int lineWidth = font.m_92895_(text);
        return lineWidth < maxWidth ? text : font.m_92834_(text, maxWidth - font.m_92895_(ELLIPSIS_STRING)) + ELLIPSIS_STRING;
    }

    public static MutableComponent concatSimple(Component ... components) {
        return TextUtils.concat(TEXT_CONCAT, components);
    }

    public static MutableComponent concat(Component concatString, Component ... components) {
        if (components.length <= 0) {
            return TextUtils.empty();
        }
        MutableComponent c = components[0].m_6881_();
        for (int i = 1; i < components.length; ++i) {
            c.m_7220_(concatString);
            c.m_7220_(components[i]);
        }
        return c;
    }

    public static MutableComponent concat(Collection<Component> components) {
        return TextUtils.concat(TEXT_CONCAT, components);
    }

    public static MutableComponent concat(Component concatString, Collection<Component> components) {
        if (components == null || components.isEmpty()) {
            return TextUtils.empty();
        }
        Iterator<Component> com = components.iterator();
        MutableComponent c = TextUtils.empty();
        if (!com.hasNext()) {
            return TextUtils.empty();
        }
        c.m_7220_(com.next());
        while (com.hasNext()) {
            c.m_7220_(concatString);
            c.m_7220_(com.next());
        }
        return c;
    }
}

