/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import java.util.Optional;
import java.util.function.Supplier;

public class TimeCache<T> {
    private T obj = null;
    private final transient Supplier<T> provider;
    private final transient ECachingPriority priority;
    private final transient long ttl;
    private transient long refreshTime = Long.MIN_VALUE;

    public TimeCache(Supplier<T> provider, long ttl, ECachingPriority priority) {
        this.provider = provider;
        this.priority = priority;
        this.ttl = ttl;
    }

    public TimeCache(Supplier<T> provider, long ttl) {
        this(provider, ttl, ECachingPriority.NORMAL);
    }

    public boolean isCached() {
        return this.obj != null;
    }

    public long getLastRefreshedTimeMillis() {
        return this.refreshTime;
    }

    public long getTTL() {
        return this.ttl;
    }

    public boolean isOutdated() {
        return System.currentTimeMillis() - this.getLastRefreshedTimeMillis() > this.ttl;
    }

    public T get() {
        if (this.isOutdated() || !this.priority.shouldCache()) {
            this.clear();
        }
        if (!this.priority.shouldCache()) {
            return this.provider.get();
        }
        if (this.isCached()) {
            return this.obj;
        }
        this.refreshTime = System.currentTimeMillis();
        this.obj = this.provider.get();
        return this.obj;
    }

    public Optional<T> getIfAvailable() {
        return !this.isCached() || this.isOutdated() ? Optional.empty() : Optional.of(this.obj);
    }

    public void clear() {
        this.refreshTime = Long.MIN_VALUE;
        this.obj = null;
    }
}

