/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;

public class WorkerAsync {
    private final String name;
    private final Logger logger;
    private final Thread thread;
    private final Queue<Runnable> taskQueue = new LinkedList<Runnable>();
    private volatile boolean running = true;

    public WorkerAsync(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.thread = new Thread(() -> {
            logger.info(name + " worker thread has been started.");
            while (this.running) {
                Runnable task = null;
                Queue<Runnable> queue = this.taskQueue;
                synchronized (queue) {
                    while (this.taskQueue.isEmpty() && this.running) {
                        try {
                            this.taskQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.error("Error while waiting for tasks.", (Throwable)e);
                        }
                    }
                    if (!this.taskQueue.isEmpty()) {
                        task = this.taskQueue.poll();
                    }
                }
                if (task == null) continue;
                try {
                    task.run();
                }
                catch (Exception e) {
                    logger.error("Error while executing task.", (Throwable)e);
                }
            }
            logger.info(name + " worker thread has been stopped!");
        }, name);
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.logger.info("Starting " + this.name + " worker thread...");
        this.taskQueue.clear();
        this.running = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(Runnable task) {
        Queue<Runnable> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.add(task);
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks() {
        Queue<Runnable> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.clear();
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.logger.info("Stopping " + this.name + " worker thread...");
        Queue<Runnable> queue = this.taskQueue;
        synchronized (queue) {
            this.running = false;
            this.clearTasks();
        }
    }
}

