/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.math;

import java.util.Objects;

public class Size {
    public static final Size EMPTY = new Size(0.0, 0.0);
    public static final Size INFINITY = new Size(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    protected double w;
    protected double h;

    protected Size(double w, double h) {
        this.w = w;
        this.h = h;
    }

    public static Size of(double w, double h) {
        if (w < 0.0 || h < 0.0) {
            throw new IllegalArgumentException(String.format("width and height must not be negative! width=%s, height=%s", w, h));
        }
        return new Size(w, h);
    }

    public double w() {
        return this.w;
    }

    public double h() {
        return this.h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Size) {
            Size o = (Size)obj;
            return this.w == o.w && this.h == o.h;
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.w, this.h);
    }

    public String toString() {
        return String.format("Size[xw=%s,h=%s]", this.w, this.h);
    }
}

