/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.properties;

import de.mrjulsen.mcdragonlib.client.gui.widgets.util.BitflagEnum;
import de.mrjulsen.mcdragonlib.util.properties.AbstractSerializableProperty;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;

public class BitflagProperty<T extends Enum<T>>
extends AbstractSerializableProperty<T[], Long> {
    private final Class<T> type;

    @SafeVarargs
    public BitflagProperty(Class<T> type, T ... defaultValue) {
        super(defaultValue);
        this.type = type;
    }

    public boolean has(T value) {
        if (value == null) {
            return this.isEmpty();
        }
        return ((Long)this.getSerializedCurrentValue() & ((BitflagEnum)value).getBit()) != 0L;
    }

    @SafeVarargs
    public final boolean hasAny(T ... values) {
        Objects.requireNonNull(values);
        for (T value : values) {
            if (((Long)this.getSerializedCurrentValue() & ((BitflagEnum)value).getBit()) == 0L) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean hasOnly(T ... values) {
        Objects.requireNonNull(values);
        int combined = 0;
        for (T value : values) {
            combined = (int)((long)combined | ((BitflagEnum)value).getBit());
        }
        return (Long)this.getSerializedCurrentValue() == (long)combined;
    }

    @SafeVarargs
    public final boolean hasAll(T ... values) {
        Objects.requireNonNull(values);
        for (T value : values) {
            if (((Long)this.getSerializedCurrentValue() & ((BitflagEnum)value).getBit()) != 0L) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public final boolean hasNone(T ... values) {
        Objects.requireNonNull(values);
        for (T value : values) {
            if (((Long)this.getSerializedValue() & ((BitflagEnum)value).getBit()) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean hasMatching(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        for (Enum constant : (Enum[])this.type.getEnumConstants()) {
            if (((Long)this.getSerializedCurrentValue() & ((BitflagEnum)((Object)constant)).getBit()) == 0L || !predicate.test(constant)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return (Long)this.getSerializedCurrentValue() == 0L;
    }

    public boolean isSingle() {
        return Long.bitCount((Long)this.getSerializedCurrentValue()) == 1;
    }

    @SafeVarargs
    public final T[] set2(T ... values) {
        return (Enum[])this.set(values);
    }

    @Override
    public T[] set(EnumSet<T> t) {
        return this.set(t.toArray((Enum[])Array.newInstance(this.type, t.size())));
    }

    @SafeVarargs
    public final void add(T ... t) {
        Enum[] old = (Enum[])this.get();
        Enum[] val = (Enum[])this.getModificationCallback().map(x -> x.update(old, t)).orElse((Enum[])t);
        this.serializeInto((Long)this.getSerializedValue(), val);
        this.getAfterChangeCallback().ifPresent(x -> x.update(old, val));
    }

    @Override
    protected Long serialize(T[] t) {
        return this.serializeInto(0L, (Enum[])t);
    }

    @SafeVarargs
    protected final long serializeInto(long flags, T ... t) {
        for (T v : t) {
            flags |= ((BitflagEnum)v).getBit();
        }
        return flags;
    }

    @Override
    protected T[] deserialize(Long flags) {
        EnumSet<Enum> set = EnumSet.noneOf(this.type);
        for (Enum constant : (Enum[])this.type.getEnumConstants()) {
            if ((flags & ((BitflagEnum)((Object)constant)).getBit()) == 0L) continue;
            set.add(constant);
        }
        return set.toArray((Enum[])Array.newInstance(this.type, set.size()));
    }
}

