/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.properties;

import java.util.Objects;
import java.util.Optional;

public class NullableProperty<T> {
    private final Optional<T> defaultValue;
    private Optional<T> value;

    public NullableProperty(T defaultValue) {
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    public Optional<T> get() {
        return this.value;
    }

    public Optional<T> set(T value) {
        this.value = Optional.ofNullable(value);
        return this.value;
    }

    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    public Optional<T> reset() {
        this.value = this.defaultValue;
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullableProperty) {
            NullableProperty o = (NullableProperty)obj;
            return this.value.map(x -> o.value.map(y -> y.equals(x)).orElse(false)).orElse(false);
        }
        return false;
    }

    public int hashCode() {
        if (!this.value.isPresent()) {
            return super.hashCode();
        }
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return String.format("Property[value=%s,defaultValue=%s]", this.value, this.defaultValue);
    }
}

