/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.properties;

import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Supplier;

public class NumberProperty<T extends Number>
extends Property<T> {
    private static final double MAX_DOUBLE = 8.988465674311579E307;
    private final Supplier<T> minSupplier;
    private final Supplier<T> maxSupplier;
    private final T minValue;
    private final T maxValue;

    public NumberProperty(T defaultValue) {
        this(defaultValue, NumberProperty.findMinBound(defaultValue), NumberProperty.findMaxBound(defaultValue));
    }

    public NumberProperty(T defaultValue, Supplier<T> min, Supplier<T> max) {
        super(defaultValue);
        this.minSupplier = min;
        this.maxSupplier = max;
        this.minValue = null;
        this.maxValue = null;
    }

    public NumberProperty(T defaultValue, T min, T max) {
        super(defaultValue);
        this.minSupplier = null;
        this.maxSupplier = null;
        this.minValue = min;
        this.maxValue = max;
    }

    @Override
    public T set(T value) {
        Objects.requireNonNull(value);
        if (((Comparable)value).compareTo(this.min()) < 0) {
            value = this.min();
        } else if (((Comparable)value).compareTo(this.max()) > 0) {
            value = this.max();
        }
        return (T)((Number)super.set(value));
    }

    public T min() {
        return (T)(this.minSupplier != null ? (Number)this.minSupplier.get() : this.minValue);
    }

    public T max() {
        return (T)(this.maxSupplier != null ? (Number)this.maxSupplier.get() : this.maxValue);
    }

    private static <E extends Number> E findMinBound(E typeInstance) {
        if (typeInstance instanceof Integer) {
            return (E)Integer.valueOf(Integer.MIN_VALUE);
        }
        if (typeInstance instanceof Double) {
            return (E)Double.valueOf(-8.988465674311579E307);
        }
        if (typeInstance instanceof Long) {
            return (E)Long.valueOf(Long.MIN_VALUE);
        }
        if (typeInstance instanceof Float) {
            return (E)Float.valueOf(Float.MIN_VALUE);
        }
        if (typeInstance instanceof Short) {
            return (E)Short.valueOf((short)Short.MIN_VALUE);
        }
        if (typeInstance instanceof Byte) {
            return (E)Byte.valueOf((byte)-128);
        }
        if (typeInstance instanceof BigInteger || typeInstance instanceof BigDecimal) {
            throw new IllegalArgumentException(typeInstance.getClass().getSimpleName() + " has no fixed bounds and cannot be initialized automatically.");
        }
        throw new IllegalArgumentException("Unknown Number type for automatic limit values: " + typeInstance.getClass().getName());
    }

    private static <E extends Number> E findMaxBound(E typeInstance) {
        if (typeInstance instanceof Integer) {
            return (E)Integer.valueOf(Integer.MAX_VALUE);
        }
        if (typeInstance instanceof Double) {
            return (E)Double.valueOf(8.988465674311579E307);
        }
        if (typeInstance instanceof Long) {
            return (E)Long.valueOf(Long.MAX_VALUE);
        }
        if (typeInstance instanceof Float) {
            return (E)Float.valueOf(Float.MAX_VALUE);
        }
        if (typeInstance instanceof Short) {
            return (E)Short.valueOf((short)Short.MAX_VALUE);
        }
        if (typeInstance instanceof Byte) {
            return (E)Byte.valueOf((byte)127);
        }
        if (typeInstance instanceof BigInteger || typeInstance instanceof BigDecimal) {
            throw new IllegalArgumentException(typeInstance.getClass().getSimpleName() + " has no fixed bounds and cannot be initialized automatically.");
        }
        throw new IllegalArgumentException("Unknown Number type for automatic limit values: " + typeInstance.getClass().getName());
    }
}

