/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import com.google.common.base.Suppliers;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ModCommonConfig;
import de.mrjulsen.mcdragonlib.config.ModServerConfig;
import de.mrjulsen.mcdragonlib.util.TimeCache;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTimeApi;
import de.mrjulsen.mcdragonlib.util.time.DLTimeOfDay;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.TimePool;
import de.mrjulsen.mcdragonlib.util.time.VanillaTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.datapack.TimeSystemDatapackLoader;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class DLTime
implements Comparable<DLTime> {
    private static final Supplier<TimeCache<ITimeSystem>> timeSystemCache = Suppliers.memoize(() -> new TimeCache<ITimeSystem>(() -> {
        ITimeSystem fallback = (Boolean)ModServerConfig.USE_CUSTOM.get() != false ? ConfiguredTimeSystem.INSTANCE : VanillaTimeSystem.INSTANCE;
        return TimeSystemDatapackLoader.getTimeSystem().orElseGet(() -> {
            if (((Boolean)ModServerConfig.AUTO_DETECT_TIME_SYSTEM.get()).booleanValue()) {
                return DLTimeApi.getCurrentCompat().orElse(fallback);
            }
            return fallback;
        });
    }, ((Integer)ModCommonConfig.TIME_SYSTEM_CACHE_TTL.get()).intValue()));
    private final double realMillis;
    @Deprecated(forRemoval=true)
    private final ITimeSystem initialSystem;

    public static ITimeSystem defaultTimeSystem() {
        return timeSystemCache.get().get();
    }

    DLTime(double realMillis) {
        this.realMillis = realMillis;
        this.initialSystem = VanillaTimeSystem.INSTANCE;
    }

    public DLTime(double amount, DLTimeUnit unit) {
        this.realMillis = unit.toMillis(amount);
        this.initialSystem = VanillaTimeSystem.INSTANCE;
    }

    public DLTime(double ticks, ITimeSystem system) {
        Objects.requireNonNull(system);
        this.realMillis = system.getRealMillisFromTicks(ticks, 0.0);
        this.initialSystem = system;
    }

    public DLTime(Level level, ITimeSystem system) {
        this((double)level.m_46468_(), system);
    }

    public static DLTime fromReal(double amount, DLTimeUnit unit) {
        return new DLTime(amount, unit);
    }

    public static DLTime fromGameTicks(double ticks, ITimeSystem system) {
        return new DLTime(ticks, system);
    }

    public static DLTime fromGameSeconds(double seconds, ITimeSystem system) {
        return new DLTime(seconds * DLTimeUnit.SECONDS.getTicks(system), system);
    }

    public static DLTime fromGameMinutes(double minutes, ITimeSystem system) {
        return DLTime.fromGameSeconds(minutes * 60.0, system);
    }

    public static DLTime fromGameHours(double hours, ITimeSystem system) {
        return DLTime.fromGameSeconds(hours * 3600.0, system);
    }

    public static DLTime fromGameDays(double days, ITimeSystem system) {
        return DLTime.fromGameTicks(days * (double)system.getTicksPerDay(), system);
    }

    public static Builder builder() {
        return new Builder();
    }

    public double toRealMillis() {
        return this.realMillis;
    }

    public double toReal(DLTimeUnit unit) {
        return this.realMillis / unit.millis;
    }

    public double toTicks(ITimeSystem system) {
        DLTime.requireSystem(system);
        return system.getTicksFromRealMillis(this.realMillis, 0.0);
    }

    public double toGameSeconds(ITimeSystem system) {
        return this.toTicks(system) / DLTimeUnit.SECONDS.getTicks(system);
    }

    public double toGameMinutes(ITimeSystem system) {
        return this.toGameSeconds(system) / 60.0;
    }

    public double toGameHours(ITimeSystem system) {
        return this.toGameMinutes(system) / 60.0;
    }

    public double toGameDays(ITimeSystem system) {
        return this.toTicks(system) / (double)system.getTicksPerDay();
    }

    public double getAmount(DLTimeUnit unit, TimeContext context, @Nullable ITimeSystem system) {
        if (context == TimeContext.REAL) {
            if (unit == DLTimeUnit.TICKS) {
                DLTime.requireSystem(system);
                return this.toTicks(system);
            }
            return this.toReal(unit);
        }
        DLTime.requireSystem(system);
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case DLTimeUnit.TICKS -> this.toTicks(system);
            case DLTimeUnit.SECONDS -> this.toGameSeconds(system);
            case DLTimeUnit.MINUTES -> this.toGameMinutes(system);
            case DLTimeUnit.HOURS -> this.toGameHours(system);
            case DLTimeUnit.DAYS -> this.toGameDays(system);
            case DLTimeUnit.MILLIS -> this.toRealMillis();
        };
    }

    public DLTime add(DLTime other) {
        return new DLTime(this.realMillis + other.realMillis);
    }

    public DLTime sub(DLTime other) {
        return new DLTime(this.realMillis - other.realMillis);
    }

    public DLTime addReal(double amount, DLTimeUnit unit) {
        return new DLTime(this.realMillis + unit.toMillis(amount));
    }

    public DLTime addGameTicks(double ticks, ITimeSystem system) {
        DLTime.requireSystem(system);
        double startTick = this.toTicks(system);
        double addedMillis = system.getRealMillisFromTicks(ticks, startTick);
        return new DLTime(this.realMillis + addedMillis);
    }

    public DLTime addGameSeconds(double seconds, ITimeSystem system) {
        return this.addGameTicks(seconds * DLTimeUnit.SECONDS.getTicks(system), system);
    }

    public DLTime addGameMinutes(double minutes, ITimeSystem system) {
        return this.addGameSeconds(minutes * 60.0, system);
    }

    public DLTime addGameHours(double hours, ITimeSystem system) {
        return this.addGameMinutes(hours * 60.0, system);
    }

    public DLTime addGameDays(double days, ITimeSystem system) {
        return this.addGameTicks(days * (double)system.getTicksPerDay(), system);
    }

    public TimePool asPool() {
        return new TimePool(this);
    }

    public String format(ITimeFormatter formatter, TimeContext context, ITimeSystem system) {
        return formatter.format(this, context, system);
    }

    public boolean isBetweenDaily(DLTime start, DLTime end, ITimeSystem system) {
        DLTimeOfDay now = new DLTimeOfDay(this, system);
        DLTimeOfDay s = new DLTimeOfDay(start, system);
        DLTimeOfDay e = new DLTimeOfDay(end, system);
        return now.isBetween(s, e);
    }

    private static void requireSystem(ITimeSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("ITimeSystem is required for this operation.");
        }
    }

    @Override
    public int compareTo(DLTime o) {
        return Double.compare(this.realMillis, o.realMillis);
    }

    public int hashCode() {
        return (int)(31.0 * this.realMillis);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DLTime) {
            DLTime o = (DLTime)obj;
            return this.realMillis == o.realMillis;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[%st]", this.getClass().getSimpleName(), this.realMillis);
    }

    public static double getCurrentTimeZoneTPS() {
        ITimeSystem system = DLTime.defaultTimeSystem();
        long ticksPerDay = system.getTicksPerDay();
        double worldTick = DragonLib.getCurrentWorldTime();
        double tickInDay = (double)Math.floorMod((long)worldTick, ticksPerDay) + (worldTick - Math.floor(worldTick));
        return system.getTimeZones().stream().sorted().filter(z -> tickInDay >= (double)z.startTick() && tickInDay < (double)z.endTick()).findFirst().map(z -> 1000.0 / z.getRealMillisPerTick()).orElse(0.0);
    }

    public static double getCurrentTimeZoneVanillaTpsRatio() {
        double timeZoneTps = DLTime.getCurrentTimeZoneTPS();
        return 20.0 / timeZoneTps;
    }

    @Deprecated(forRemoval=true)
    public static DLTime fromTicks(double ticks, ITimeSystem provider) {
        return DLTime.fromGameTicks(ticks, provider);
    }

    @Deprecated(forRemoval=true)
    public static DLTime fromLevelTime(Level level, ITimeSystem provider) {
        return new DLTime(level, provider);
    }

    @Deprecated(forRemoval=true)
    public static DLTime now(ITimeSystem provider) {
        long millis = System.currentTimeMillis();
        double ticks = provider.getTicksFromRealMillis(millis, 0.0);
        return DLTime.fromGameTicks(ticks, provider);
    }

    @Deprecated(forRemoval=true)
    public double toRealSeconds() {
        return this.toReal(DLTimeUnit.SECONDS);
    }

    @Deprecated(forRemoval=true)
    public double toRealMinutes() {
        return this.toReal(DLTimeUnit.MINUTES);
    }

    @Deprecated(forRemoval=true)
    public double toRealHours() {
        return this.toReal(DLTimeUnit.HOURS);
    }

    @Deprecated(forRemoval=true)
    public double toRealDays() {
        return this.toReal(DLTimeUnit.DAYS);
    }

    @Deprecated(forRemoval=true)
    public DLTime addGameDays(long days, ITimeSystem provider) {
        return this.addGameDays((double)days, provider);
    }

    @Deprecated(forRemoval=true)
    public DLTime addGameHours(long hours, ITimeSystem provider) {
        return this.addGameHours((double)hours, provider);
    }

    @Deprecated(forRemoval=true)
    public DLTime addGameMinutes(long minutes, ITimeSystem provider) {
        return this.addGameMinutes((double)minutes, provider);
    }

    @Deprecated(forRemoval=true)
    public DLTime addGameSeconds(long seconds, ITimeSystem provider) {
        return this.addGameSeconds((double)seconds, provider);
    }

    @Deprecated(forRemoval=true)
    public DLTime addRealMilliseconds(long ms) {
        return this.addReal(ms, DLTimeUnit.MILLIS);
    }

    @Deprecated(forRemoval=true)
    public DLTime addRealSeconds(long seconds) {
        return this.addReal(seconds, DLTimeUnit.SECONDS);
    }

    @Deprecated(forRemoval=true)
    public DLTime addRealMinutes(long minutes) {
        return this.addReal(minutes, DLTimeUnit.MINUTES);
    }

    @Deprecated(forRemoval=true)
    public DLTime addRealHours(long hours) {
        return this.addReal(hours, DLTimeUnit.HOURS);
    }

    @Deprecated(forRemoval=true)
    public DLTime addRealDays(long days) {
        return this.addReal(days, DLTimeUnit.DAYS);
    }

    @Deprecated(forRemoval=true)
    public boolean isBefore(DLTime other) {
        return this.compareTo(other) < 0;
    }

    @Deprecated(forRemoval=true)
    public boolean isAfter(DLTime other) {
        return this.compareTo(other) > 0;
    }

    @Deprecated(forRemoval=true)
    public boolean isBetween(DLTime start, DLTime end) {
        double now = this.realMillis;
        double a = start.realMillis;
        double b = end.realMillis;
        return a <= b ? now >= a && now <= b : now >= b && now <= a;
    }

    @Deprecated(forRemoval=true)
    public String format(ITimeFormatter formatter, TimeContext context) {
        return formatter.format(this, context, VanillaTimeSystem.INSTANCE);
    }

    @Deprecated(forRemoval=true)
    public static DLTime fromIngame(long days, int hours, int minutes, int seconds, ITimeSystem system) {
        DLTime.requireSystem(system);
        double ticksPerSecond = DLTimeUnit.SECONDS.getTicks(system);
        double totalTicks = 0.0;
        totalTicks += (double)days * (double)system.getTicksPerDay();
        totalTicks += (double)hours * 3600.0 * ticksPerSecond;
        totalTicks += (double)minutes * 60.0 * ticksPerSecond;
        return new DLTime(totalTicks += (double)seconds * ticksPerSecond, system);
    }

    @Deprecated(forRemoval=true)
    public static DLTime fromReal(long days, int hours, int minutes, int seconds, int millis, ITimeSystem system) {
        double totalMillis = 0.0;
        totalMillis += (double)millis;
        totalMillis += (double)seconds * 1000.0;
        totalMillis += (double)minutes * 60000.0;
        totalMillis += (double)hours * 3600000.0;
        return new DLTime(totalMillis += (double)days * 8.64E7);
    }

    @Deprecated(forRemoval=true)
    public double toTicks() {
        return this.toTicks(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public double toGameSeconds() {
        return this.toGameSeconds(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public double toGameMinutes() {
        return this.toGameMinutes(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public double toGameHours() {
        return this.toGameHours(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public double toGameDays() {
        return this.toGameDays(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public double getTicks() {
        return this.toTicks(this.initialSystem);
    }

    @Deprecated(forRemoval=true)
    public TimeSnapshot decomposeGameTime() {
        TimePool pool = this.asPool();
        return new TimeSnapshot((int)pool.extractGameDays(this.initialSystem), (int)pool.extractGameHours(this.initialSystem), (int)pool.extractGameMinutes(this.initialSystem), (int)pool.extractGameSeconds(this.initialSystem), (int)pool.extractGameTicks(this.initialSystem));
    }

    @Deprecated(forRemoval=true)
    public TimeSnapshot decomposeRealTime() {
        TimePool pool = this.asPool();
        return new TimeSnapshot((int)pool.extractDays(), (int)pool.extractHours(), (int)pool.extractMinutes(), (int)pool.extractSeconds(), (int)pool.extractMillis());
    }

    public static final class Builder {
        private double millis;

        private Builder() {
        }

        public Builder real(double amount, DLTimeUnit unit) {
            this.millis += unit.toMillis(amount);
            return this;
        }

        public Builder gameTicks(double ticks, ITimeSystem system) {
            this.millis += system.getRealMillisFromTicks(ticks, 0.0);
            return this;
        }

        public Builder gameSeconds(double seconds, ITimeSystem system) {
            return this.gameTicks(seconds * DLTimeUnit.SECONDS.getTicks(system), system);
        }

        public Builder gameMinutes(double minutes, ITimeSystem system) {
            return this.gameSeconds(minutes * 60.0, system);
        }

        public Builder gameHours(double hours, ITimeSystem system) {
            return this.gameMinutes(hours * 60.0, system);
        }

        public Builder gameDays(double days, ITimeSystem system) {
            return this.gameTicks(days * (double)system.getTicksPerDay(), system);
        }

        public DLTime build() {
            return new DLTime(this.millis);
        }
    }

    @Deprecated(forRemoval=true)
    public record TimeSnapshot(long days, int hours, int minutes, int seconds, int millis) {
    }
}

