/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.config.ModServerConfig;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import dev.architectury.platform.Platform;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class DLTimeApi {
    private static final Map<String, Supplier<ITimeSystem>> compatTimeSystems = new ConcurrentHashMap<String, Supplier<ITimeSystem>>();

    private DLTimeApi() {
    }

    public static void registerCompat(String modid, Supplier<ITimeSystem> timeSystem) {
        compatTimeSystems.put(modid, timeSystem);
    }

    public static boolean hasCompatForMod(String modid) {
        return compatTimeSystems.containsKey(modid);
    }

    static Optional<ITimeSystem> getCurrentCompat() {
        String preferredMod = (String)ModServerConfig.PREFERRED_MOD.get();
        boolean hasPreference = !preferredMod.isBlank();
        for (Map.Entry<String, Supplier<ITimeSystem>> pair : compatTimeSystems.entrySet()) {
            if (!Platform.isModLoaded((String)pair.getKey()) || hasPreference && !pair.getKey().toLowerCase().equals(preferredMod.toLowerCase())) continue;
            return Optional.ofNullable(pair.getValue().get());
        }
        return Optional.empty();
    }
}

