/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import org.jetbrains.annotations.NotNull;

public final class DLTimeOfDay {
    private final double ticksInDay;

    public DLTimeOfDay(@NotNull DLTime time, @NotNull ITimeSystem system) {
        double absoluteTicks = time.toTicks(system);
        long ticksPerDay = system.getTicksPerDay();
        double offset = system.getDaytimeOffset();
        this.ticksInDay = (absoluteTicks + offset) % (double)ticksPerDay;
    }

    public double getTicks() {
        return this.ticksInDay;
    }

    public double getSeconds(@NotNull ITimeSystem system) {
        return this.ticksInDay / ((double)system.getTicksPerDay() / 86400.0);
    }

    public double getMinutes(@NotNull ITimeSystem system) {
        return this.getSeconds(system) / 60.0;
    }

    public double getHours(@NotNull ITimeSystem system) {
        return this.getMinutes(system) / 60.0;
    }

    public boolean isBetween(@NotNull DLTimeOfDay start, @NotNull DLTimeOfDay end) {
        double e;
        double s = start.getTicks();
        if (s <= (e = end.getTicks())) {
            return this.ticksInDay >= s && this.ticksInDay <= e;
        }
        return this.ticksInDay >= s || this.ticksInDay <= e;
    }

    public double getHourOfDay(@NotNull ITimeSystem system) {
        double hours = this.getHours(system);
        double h = hours % 24.0;
        if (h < 0.0) {
            h += 24.0;
        }
        return h;
    }

    public double getMinuteOfHour(@NotNull ITimeSystem system) {
        double totalMinutes = this.getMinutes(system);
        double minute = totalMinutes % 60.0;
        if (minute < 0.0) {
            minute += 60.0;
        }
        return minute;
    }

    public double getSecondOfMinute(@NotNull ITimeSystem system) {
        double totalSeconds = this.getSeconds(system);
        double second = totalSeconds % 60.0;
        if (second < 0.0) {
            second += 60.0;
        }
        return second;
    }

    public double getTicksWithinSecond(@NotNull ITimeSystem system) {
        double ticksPerSecond = (double)system.getTicksPerDay() / 86400.0;
        if (ticksPerSecond == 0.0) {
            return 0.0;
        }
        double rem = this.ticksInDay - Math.floor(this.ticksInDay / ticksPerSecond) * ticksPerSecond;
        if (rem < 0.0) {
            rem += ticksPerSecond;
        }
        return rem;
    }

    public int getWholeTickOfSecond(@NotNull ITimeSystem system) {
        double fractional = this.getTicksWithinSecond(system);
        return (int)Math.floor(fractional);
    }

    public int getWholeTickOfMinute(@NotNull ITimeSystem system) {
        double ticksPerSecond = (double)system.getTicksPerDay() / 86400.0;
        double ticksPerMinute = ticksPerSecond * 60.0;
        if (ticksPerMinute == 0.0) {
            return 0;
        }
        double rem = this.ticksInDay - Math.floor(this.ticksInDay / ticksPerMinute) * ticksPerMinute;
        if (rem < 0.0) {
            rem += ticksPerMinute;
        }
        return (int)Math.floor(rem);
    }
}

