/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;

public enum DLTimeUnit {
    MILLIS(1.0),
    SECONDS(1000.0),
    MINUTES(DLTimeUnit.SECONDS.millis * 60.0),
    HOURS(DLTimeUnit.MINUTES.millis * 60.0),
    DAYS(DLTimeUnit.HOURS.millis * 24.0),
    TICKS(0.0);

    public final double millis;

    private DLTimeUnit(double millis) {
        this.millis = millis;
    }

    public double toMillis(double amount) {
        return amount * this.millis;
    }

    public double getTicks(ITimeSystem system) {
        return switch (this.ordinal()) {
            case 5 -> 1.0;
            case 1 -> (double)system.getTicksPerDay() / DAYS.getSeconds();
            case 2 -> (double)system.getTicksPerDay() / DAYS.getMinutes();
            case 3 -> (double)system.getTicksPerDay() / 24.0;
            case 4 -> system.getTicksPerDay();
            default -> 0.0;
        };
    }

    public double getSeconds() {
        return this.millis / 1000.0;
    }

    public double getMinutes() {
        return this.getSeconds() / 60.0;
    }
}

