/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeZone;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class DatapackTimeSystem
implements ITimeSystem {
    private final long ticksPerDay;
    private final long daytimeOffset;
    private final List<TimeZone> timeZones;

    private DatapackTimeSystem(long ticksPerDay, long daytimeOffset, List<TimeZone> zones) {
        this.ticksPerDay = ticksPerDay;
        this.daytimeOffset = daytimeOffset;
        this.timeZones = List.copyOf(zones);
    }

    public static DatapackTimeSystem fromJson(JsonObject json) {
        long ticksPerDay = json.has("ticks_per_day") ? json.get("ticks_per_day").getAsLong() : 24000L;
        long offset = json.has("daytime_offset") ? json.get("daytime_offset").getAsLong() : 0L;
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
        if (json.has("zones")) {
            JsonArray arr = json.getAsJsonArray("zones");
            for (JsonElement el : arr) {
                JsonObject o = el.getAsJsonObject();
                long start = o.get("start_tick").getAsLong();
                long end = o.get("end_tick").getAsLong();
                double tps = o.get("tps").getAsDouble();
                zones.add(new TimeZone(start, end, tps));
            }
        }
        if (zones.isEmpty()) {
            zones.add(new TimeZone(0L, ticksPerDay, 20.0));
        }
        DatapackTimeSystem.validate(zones, ticksPerDay);
        return new DatapackTimeSystem(ticksPerDay, offset, zones);
    }

    private static void validate(List<TimeZone> zones, long ticksPerDay) {
        for (TimeZone z : zones) {
            if (z.startTick() < 0L || z.endTick() > ticksPerDay) {
                throw new IllegalArgumentException("TimeZone out of range: " + String.valueOf(z));
            }
            if (!(z.tps() <= 0.0)) continue;
            throw new IllegalArgumentException("Invalid TPS in TimeZone: " + String.valueOf(z));
        }
    }

    @Override
    public long getTicksPerDay() {
        return this.ticksPerDay;
    }

    @Override
    public double getDaytimeOffset() {
        return this.daytimeOffset;
    }

    @Override
    public List<TimeZone> getTimeZones() {
        return this.timeZones;
    }

    public String toString() {
        return "DatapackTimeSystem{ticksPerDay=" + this.ticksPerDay + ", daytimeOffset=" + this.daytimeOffset + ", zones=" + String.valueOf(this.timeZones) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.ticksPerDay, this.daytimeOffset, this.timeZones);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatapackTimeSystem)) {
            return false;
        }
        DatapackTimeSystem other = (DatapackTimeSystem)obj;
        return this.ticksPerDay == other.ticksPerDay && this.daytimeOffset == other.daytimeOffset && this.timeZones.equals(other.timeZones);
    }
}

