/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.TimeZone;
import java.util.List;

public interface ITimeSystem {
    public long getTicksPerDay();

    public List<TimeZone> getTimeZones();

    default public double getDaytimeOffset() {
        return (double)this.getTicksPerDay() / 4.0;
    }

    default public double getRealMillisFromTicks(double totalTicks, double startTick) {
        if (totalTicks <= 0.0) {
            return 0.0;
        }
        long ticksPerDay = this.getTicksPerDay();
        List<TimeZone> zones = this.getTimeZones().stream().sorted().toList();
        double millisPerFullDay = this.calculateMillisPerFullDay(zones);
        double remainingTicks = totalTicks;
        double totalRealMillis = 0.0;
        double currentTickInDay = (double)Math.floorMod((long)startTick, ticksPerDay) + (startTick - Math.floor(startTick));
        double ticksUntilEndOfDay = (double)ticksPerDay - currentTickInDay;
        if (remainingTicks <= ticksUntilEndOfDay) {
            return this.getMillisInPartialDay(remainingTicks, currentTickInDay, zones);
        }
        totalRealMillis += this.getMillisInPartialDay(ticksUntilEndOfDay, currentTickInDay, zones);
        long fullDays = (long)((remainingTicks -= ticksUntilEndOfDay) / (double)ticksPerDay);
        totalRealMillis += (double)fullDays * millisPerFullDay;
        if ((remainingTicks -= (double)fullDays * (double)ticksPerDay) > 1.0E-9) {
            totalRealMillis += this.getMillisInPartialDay(remainingTicks, 0.0, zones);
        }
        return totalRealMillis;
    }

    default public double getTicksFromRealMillis(double totalMillis, double startTick) {
        if (totalMillis <= 0.0) {
            return 0.0;
        }
        long ticksPerDay = this.getTicksPerDay();
        List<TimeZone> zones = this.getTimeZones().stream().sorted().toList();
        double millisPerFullDay = this.calculateMillisPerFullDay(zones);
        double remainingMillis = totalMillis;
        double totalTicks = 0.0;
        double currentTickInDay = (double)Math.floorMod((long)startTick, ticksPerDay) + (startTick - Math.floor(startTick));
        double millisUntilEndOfDay = this.getMillisInPartialDay((double)ticksPerDay - currentTickInDay, currentTickInDay, zones);
        if (remainingMillis <= millisUntilEndOfDay) {
            return this.getTicksInPartialDay(remainingMillis, currentTickInDay, zones);
        }
        totalTicks += (double)ticksPerDay - currentTickInDay;
        long fullDays = (long)((remainingMillis -= millisUntilEndOfDay) / millisPerFullDay);
        totalTicks += (double)fullDays * (double)ticksPerDay;
        if ((remainingMillis -= (double)fullDays * millisPerFullDay) > 1.0E-9) {
            totalTicks += this.getTicksInPartialDay(remainingMillis, 0.0, zones);
        }
        return totalTicks;
    }

    private double calculateMillisPerFullDay(List<TimeZone> zones) {
        return zones.stream().mapToDouble(z -> (double)(z.endTick() - z.startTick()) * z.getRealMillisPerTick()).sum();
    }

    private double getMillisInPartialDay(double ticks, double startTickInDay, List<TimeZone> zones) {
        double remaining = ticks;
        double millis = 0.0;
        double current = startTickInDay;
        for (TimeZone zone : zones) {
            if (remaining <= 0.0) break;
            double effectiveStart = Math.max((double)zone.startTick(), current);
            if (!(effectiveStart < (double)zone.endTick())) continue;
            double ticksInZone = Math.min(remaining, (double)zone.endTick() - effectiveStart);
            millis += ticksInZone * zone.getRealMillisPerTick();
            remaining -= ticksInZone;
            current = effectiveStart + ticksInZone;
        }
        return millis;
    }

    private double getTicksInPartialDay(double millis, double startTickInDay, List<TimeZone> zones) {
        double remaining = millis;
        double ticks = 0.0;
        double current = startTickInDay;
        for (TimeZone zone : zones) {
            if (remaining <= 0.0) break;
            double effectiveStart = Math.max((double)zone.startTick(), current);
            if (!(effectiveStart < (double)zone.endTick())) continue;
            double zoneMsPerTick = zone.getRealMillisPerTick();
            double maxTicksInZone = (double)zone.endTick() - effectiveStart;
            double maxMillisInZone = maxTicksInZone * zoneMsPerTick;
            if (remaining >= maxMillisInZone) {
                ticks += maxTicksInZone;
                remaining -= maxMillisInZone;
                current = zone.endTick();
                continue;
            }
            ticks += remaining / zoneMsPerTick;
            remaining = 0.0;
        }
        return ticks;
    }
}

