/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import org.jetbrains.annotations.Nullable;

public final class TimePool {
    private double remainingMillis;

    public TimePool(DLTime time) {
        this.remainingMillis = time.toRealMillis();
    }

    public TimePool(double realMillis) {
        this.remainingMillis = realMillis;
    }

    public double remainingRealMillis() {
        return this.remainingMillis;
    }

    public boolean isEmpty() {
        return this.remainingMillis <= 0.0;
    }

    public long extract(DLTimeUnit unit, TimeContext context, @Nullable ITimeSystem system) {
        double unitMillis;
        if (context == TimeContext.REAL) {
            unitMillis = unit.millis;
        } else {
            TimePool.requireSystem(system);
            double ticks = unit.getTicks(system);
            unitMillis = system.getRealMillisFromTicks(ticks, 0.0);
        }
        long count = (long)(this.remainingMillis / unitMillis);
        this.remainingMillis -= (double)count * unitMillis;
        return count;
    }

    public long extractMillis() {
        return this.extract(DLTimeUnit.MILLIS, TimeContext.REAL, null);
    }

    public long extractSeconds() {
        return this.extract(DLTimeUnit.SECONDS, TimeContext.REAL, null);
    }

    public long extractMinutes() {
        return this.extract(DLTimeUnit.MINUTES, TimeContext.REAL, null);
    }

    public long extractHours() {
        return this.extract(DLTimeUnit.HOURS, TimeContext.REAL, null);
    }

    public long extractDays() {
        return this.extract(DLTimeUnit.DAYS, TimeContext.REAL, null);
    }

    public long extractGameTicks(ITimeSystem system) {
        return this.extract(DLTimeUnit.TICKS, TimeContext.INGAME, system);
    }

    public long extractGameSeconds(ITimeSystem system) {
        return this.extract(DLTimeUnit.SECONDS, TimeContext.INGAME, system);
    }

    public long extractGameMinutes(ITimeSystem system) {
        return this.extract(DLTimeUnit.MINUTES, TimeContext.INGAME, system);
    }

    public long extractGameHours(ITimeSystem system) {
        return this.extract(DLTimeUnit.HOURS, TimeContext.INGAME, system);
    }

    public long extractGameDays(ITimeSystem system) {
        return this.extract(DLTimeUnit.DAYS, TimeContext.INGAME, system);
    }

    private static void requireSystem(ITimeSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("ITimeSystem is required for INGAME extraction.");
        }
    }
}

