/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TimeFormat12Hours
implements ITimeFormatter {
    public static final TimeFormat12Hours INSTANCE = new TimeFormat12Hours();

    @Deprecated(forRemoval=true)
    public TimeFormat12Hours() {
    }

    @Override
    public String format(DLTime time, TimeContext context, @Nullable ITimeSystem system) {
        int minute;
        int hour;
        if (context == TimeContext.REAL) {
            double totalMillis = time.toRealMillis();
            long totalSeconds = (long)(totalMillis / 1000.0);
            hour = (int)(totalSeconds / 3600L % 24L);
            minute = (int)(totalSeconds / 60L % 60L);
        } else {
            TimeFormat12Hours.requireSystem(system);
            long ticksPerDay = system.getTicksPerDay();
            double t = (time.toTicks(system) + system.getDaytimeOffset()) % (double)ticksPerDay;
            hour = (int)(t * 24.0 / (double)ticksPerDay);
            minute = (int)(t * 24.0 * 60.0 % (double)(ticksPerDay * 60L) / (double)ticksPerDay);
        }
        String period = hour >= 12 ? "PM" : "AM";
        int displayHour = hour % 12;
        if (displayHour == 0) {
            displayHour = 12;
        }
        return String.format("%02d:%02d %s", displayHour, minute, period);
    }

    private static void requireSystem(@Nullable ITimeSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("ITimeSystem required for Ingame time");
        }
    }
}

