/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TimeFormat24Hours
implements ITimeFormatter {
    public static final TimeFormat24Hours INSTANCE = new TimeFormat24Hours();

    @Deprecated(forRemoval=true)
    public TimeFormat24Hours() {
    }

    @Override
    public String format(DLTime time, TimeContext context, @Nullable ITimeSystem system) {
        if (context == TimeContext.REAL) {
            double totalMillis = time.toRealMillis();
            long totalSeconds = (long)(totalMillis / 1000.0);
            long hour = totalSeconds / 3600L % 24L;
            long minute = totalSeconds / 60L % 60L;
            return String.format("%02d:%02d", hour, minute);
        }
        TimeFormat24Hours.requireSystem(system);
        long ticksPerDay = system.getTicksPerDay();
        double t = (time.toTicks(system) + system.getDaytimeOffset()) % (double)ticksPerDay;
        long hour = (long)(t * 24.0 / (double)ticksPerDay);
        long minute = (long)(t * 24.0 * 60.0 % (double)(ticksPerDay * 60L) / (double)ticksPerDay);
        return String.format("%02d:%02d", hour, minute);
    }

    private static void requireSystem(@Nullable ITimeSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("ITimeSystem required for Ingame time");
        }
    }
}

