/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TimeFormatDigitalDuration
implements ITimeFormatter {
    public static final TimeFormatDigitalDuration DEFAULT_REAL_INSTANCE = new TimeFormatDigitalDuration(DLTimeUnit.SECONDS, false);
    public static final TimeFormatDigitalDuration DEFAULT_GAME_INSTANCE = new TimeFormatDigitalDuration(DLTimeUnit.MINUTES, false);
    private final DLTimeUnit minUnit;
    private final boolean includeMillisOrTicks;

    public TimeFormatDigitalDuration(DLTimeUnit minUnit, boolean includeMillisOrTicks) {
        this.minUnit = minUnit == DLTimeUnit.TICKS || minUnit == DLTimeUnit.MILLIS ? DLTimeUnit.SECONDS : minUnit;
        this.includeMillisOrTicks = includeMillisOrTicks;
    }

    @Deprecated(forRemoval=true)
    public TimeFormatDigitalDuration() {
        this(DLTimeUnit.SECONDS, false);
    }

    @Deprecated(forRemoval=true)
    public TimeFormatDigitalDuration(DLTime startTicks) {
        this(DLTimeUnit.SECONDS, false);
    }

    @Deprecated(forRemoval=true)
    public TimeFormatDigitalDuration(DLTime startTicks, boolean showMillis, boolean showSeconds, boolean showMinutes, boolean showHours, boolean showDays) {
        this(DLTimeUnit.SECONDS, false);
    }

    @Override
    public String format(DLTime time, TimeContext context, @Nullable ITimeSystem system) {
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long millis = 0L;
        if (context == TimeContext.REAL) {
            long remaining = (long)time.toRealMillis();
            if (this.minUnit.compareTo(DLTimeUnit.DAYS) <= 0) {
                days = (long)((double)remaining / DLTimeUnit.DAYS.millis);
                remaining = (long)((double)remaining - (double)days * DLTimeUnit.DAYS.millis);
            }
            if (this.minUnit.compareTo(DLTimeUnit.HOURS) <= 0) {
                hours = (long)((double)remaining / DLTimeUnit.HOURS.millis);
                remaining = (long)((double)remaining - (double)hours * DLTimeUnit.HOURS.millis);
            }
            if (this.minUnit.compareTo(DLTimeUnit.MINUTES) <= 0) {
                minutes = (long)((double)remaining / DLTimeUnit.MINUTES.millis);
                remaining = (long)((double)remaining - (double)minutes * DLTimeUnit.MINUTES.millis);
            }
            if (this.minUnit.compareTo(DLTimeUnit.SECONDS) <= 0) {
                seconds = (long)((double)remaining / DLTimeUnit.SECONDS.millis);
                remaining = (long)((double)remaining - (double)seconds * DLTimeUnit.SECONDS.millis);
            }
            millis = remaining;
        } else {
            if (system == null) {
                throw new IllegalArgumentException("ITimeSystem required for INGAME formatting.");
            }
            double ticks = time.toTicks(system);
            long ticksPerDay = system.getTicksPerDay();
            double ticksPerHour = (double)ticksPerDay / 24.0;
            double ticksPerMinute = ticksPerHour / 60.0;
            double ticksPerSecond = ticksPerMinute / 60.0;
            if (this.minUnit.compareTo(DLTimeUnit.DAYS) <= 0) {
                days = (long)(ticks / (double)ticksPerDay);
                ticks -= (double)(days * ticksPerDay);
            }
            if (this.minUnit.compareTo(DLTimeUnit.HOURS) <= 0) {
                hours = (long)(ticks / ticksPerHour);
                ticks -= (double)hours * ticksPerHour;
            }
            if (this.minUnit.compareTo(DLTimeUnit.MINUTES) <= 0) {
                minutes = (long)(ticks / ticksPerMinute);
                ticks -= (double)minutes * ticksPerMinute;
            }
            if (this.minUnit.compareTo(DLTimeUnit.SECONDS) <= 0) {
                seconds = (long)(ticks / ticksPerSecond);
                ticks -= (double)seconds * ticksPerSecond;
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        if (days > 0L || this.minUnit == DLTimeUnit.DAYS) {
            sb.append(String.format("%02d", days));
            started = true;
        }
        if (hours > 0L || started || this.minUnit == DLTimeUnit.HOURS) {
            if (started) {
                sb.append(":");
            }
            sb.append(String.format("%02d", hours));
            started = true;
        }
        if (minutes > 0L || started || this.minUnit == DLTimeUnit.MINUTES) {
            if (started) {
                sb.append(":");
            }
            sb.append(String.format("%02d", minutes));
            started = true;
        }
        if (seconds > 0L || started || this.minUnit == DLTimeUnit.SECONDS) {
            if (started) {
                sb.append(":");
            }
            sb.append(String.format("%02d", seconds));
        }
        if (this.includeMillisOrTicks) {
            if (context == TimeContext.REAL && millis > 0L) {
                sb.append(".").append(String.format("%03d", millis));
            } else if (context == TimeContext.INGAME && system != null) {
                sb.append(".").append(String.format("%02d", (long)(time.toTicks(system) % 20.0))).append("t");
            }
        }
        return sb.toString();
    }
}

