/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TimeFormatISO8601
implements ITimeFormatter {
    public static final TimeFormatISO8601 INSTANCE = new TimeFormatISO8601();

    @Override
    public String format(DLTime time, TimeContext context, @Nullable ITimeSystem system) {
        double totalSeconds = context == TimeContext.REAL ? time.toReal(DLTimeUnit.SECONDS) : time.toGameSeconds(system);
        long days = (long)(totalSeconds / 86400.0);
        long hours = (long)(totalSeconds % 86400.0 / 3600.0);
        long minutes = (long)(totalSeconds % 3600.0 / 60.0);
        long seconds = (long)(totalSeconds % 60.0);
        return String.format("P%dDT%dH%dM%dS", days, hours, minutes, seconds);
    }
}

