/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TimeFormatVerboseDuration
implements ITimeFormatter {
    public static final TimeFormatVerboseDuration DEFAULT_INSTANCE = new TimeFormatVerboseDuration(new Config().showDays(true).showHours(true).showMinutes(true).showSeconds(true));
    private final Config config;

    public TimeFormatVerboseDuration(Config config) {
        this.config = config;
    }

    @Override
    public String format(DLTime time, TimeContext context, @Nullable ITimeSystem system) {
        StringBuilder sb = new StringBuilder();
        if (context == TimeContext.REAL) {
            long ms;
            long s;
            long m;
            long h;
            long d;
            long remaining = (long)time.toRealMillis();
            if (this.config.showDays && (d = (long)((double)remaining / DLTimeUnit.DAYS.millis)) > 0L) {
                sb.append(d).append("d ");
                remaining = (long)((double)remaining - (double)d * DLTimeUnit.DAYS.millis);
            }
            if (this.config.showHours && (h = (long)((double)remaining / DLTimeUnit.HOURS.millis)) > 0L) {
                sb.append(h).append("h ");
                remaining = (long)((double)remaining - (double)h * DLTimeUnit.HOURS.millis);
            }
            if (this.config.showMinutes && (m = (long)((double)remaining / DLTimeUnit.MINUTES.millis)) > 0L) {
                sb.append(m).append("m ");
                remaining = (long)((double)remaining - (double)m * DLTimeUnit.MINUTES.millis);
            }
            if (this.config.showSeconds && (s = (long)((double)remaining / DLTimeUnit.SECONDS.millis)) > 0L) {
                sb.append(s).append("s ");
                remaining = (long)((double)remaining - (double)s * DLTimeUnit.SECONDS.millis);
            }
            if (this.config.showMillis && (ms = remaining) > 0L) {
                sb.append(ms).append("ms ");
            }
        } else {
            long s;
            long m;
            long h;
            long d;
            if (system == null) {
                throw new IllegalArgumentException("ITimeSystem required for INGAME formatting.");
            }
            double ticks = time.toTicks(system);
            long ticksPerDay = system.getTicksPerDay();
            double ticksPerHour = (double)ticksPerDay / 24.0;
            double ticksPerMinute = ticksPerHour / 60.0;
            double ticksPerSecond = ticksPerMinute / 60.0;
            if (this.config.showDays && (d = (long)(ticks / (double)ticksPerDay)) > 0L) {
                sb.append(d).append("d ");
                ticks -= (double)(d * ticksPerDay);
            }
            if (this.config.showHours && (h = (long)(ticks / ticksPerHour)) > 0L) {
                sb.append(h).append("h ");
                ticks -= (double)h * ticksPerHour;
            }
            if (this.config.showMinutes && (m = (long)(ticks / ticksPerMinute)) > 0L) {
                sb.append(m).append("m ");
                ticks -= (double)m * ticksPerMinute;
            }
            if (this.config.showSeconds && (s = (long)(ticks / ticksPerSecond)) > 0L) {
                sb.append(s).append("s ");
            }
            if (this.config.showTicks) {
                sb.append((long)time.toTicks(system)).append("t ");
            }
        }
        String result = sb.toString().trim();
        return result.isEmpty() ? "0" : result;
    }

    public static class Config {
        private boolean showDays = false;
        private boolean showHours = false;
        private boolean showMinutes = false;
        private boolean showSeconds = false;
        private boolean showMillis = false;
        private boolean showTicks = false;

        public Config showDays(boolean b) {
            this.showDays = b;
            return this;
        }

        public Config showHours(boolean b) {
            this.showHours = b;
            return this;
        }

        public Config showMinutes(boolean b) {
            this.showMinutes = b;
            return this;
        }

        public Config showSeconds(boolean b) {
            this.showSeconds = b;
            return this;
        }

        public Config showMillis(boolean b) {
            this.showMillis = b;
            return this;
        }

        public Config showTicks(boolean b) {
            this.showTicks = b;
            return this;
        }
    }
}

