/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.time.format;

import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.format.ITimeFormatter;

@Deprecated(forRemoval=true)
public class TimeFormaturVerboseDuration
implements ITimeFormatter {
    private DLTime startTime;
    private boolean showMillis;
    private boolean showSeconds;
    private boolean showMinutes;
    private boolean showHours;
    private boolean showDays;

    @Deprecated(forRemoval=true)
    public TimeFormaturVerboseDuration() {
    }

    @Deprecated(forRemoval=true)
    public TimeFormaturVerboseDuration(DLTime startTicks, boolean showMillis, boolean showSeconds, boolean showMinutes, boolean showHours, boolean showDays) {
        this.startTime = startTicks;
        this.showMillis = showMillis;
        this.showSeconds = showSeconds;
        this.showMinutes = showMinutes;
        this.showHours = showHours;
        this.showDays = showDays;
    }

    @Override
    @Deprecated(forRemoval=true)
    public String format(DLTime time, TimeContext context, ITimeSystem system) {
        String result;
        boolean negative = false;
        ITimeSystem provider = system;
        double totalMillis = 0.0;
        if (context == TimeContext.REAL) {
            double totalMillisOrTicks;
            if (this.startTime != null) {
                deltaTicks = time.toTicks(system) - this.startTime.toTicks(system);
                totalMillisOrTicks = provider.getRealMillisFromTicks(deltaTicks, this.startTime.toTicks(system));
            } else {
                totalMillisOrTicks = time.toRealMillis();
            }
            if (Double.isNaN(totalMillisOrTicks) || Double.isInfinite(totalMillisOrTicks)) {
                return "NaN";
            }
            if (totalMillisOrTicks < 0.0) {
                negative = true;
            }
            totalMillis = Math.abs(Math.round(totalMillisOrTicks));
        } else {
            deltaTicks = this.startTime != null ? time.toTicks(system) - this.startTime.toTicks(system) : time.toTicks(system);
            if (Double.isNaN(deltaTicks) || Double.isInfinite(deltaTicks)) {
                return "NaN";
            }
            if (deltaTicks < 0.0) {
                negative = true;
            }
            totalMillis = Math.abs(deltaTicks / ((double)provider.getTicksPerDay() / 8.64E7));
        }
        long millis = (long)(totalMillis % 1000.0);
        long totalSeconds = (long)(totalMillis / 1000.0);
        long seconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long minutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        long hours = totalHours % 24L;
        long days = totalHours / 24L;
        StringBuilder sb = new StringBuilder();
        if (this.showDays && days > 0L) {
            sb.append(days).append("d ");
        }
        if (this.showHours && hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (this.showMinutes && minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (this.showSeconds && seconds > 0L) {
            sb.append(seconds).append("s ");
        }
        if (this.showMillis && millis > 0L) {
            sb.append(millis).append("ms ");
        }
        if ((result = sb.toString().trim()).isEmpty()) {
            result = this.showMillis ? "0ms" : (this.showSeconds ? "0s" : (this.showMillis ? "0m" : "0"));
        }
        return negative ? "-" + result : result;
    }
}

