/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClockBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_NORTH_2 = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_SOUTH_2 = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_2, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST_2 = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_2, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST_2 = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_2, (Direction)Direction.WEST);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty HOUR = ModBlockProperties.HOUR;
    public static final BooleanProperty TWO_FACED = ModBlockProperties.TWO_FACED;

    public ClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TWO_FACED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void displayCurrentHour(Level world, Player player) {
        int time = (int)(world.m_46468_() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        Object ob = "";
        Object br = "";
        if (!world.m_6042_().f_63858_()) {
            time = world.f_46441_.m_188503_(24000);
            ob = (String)ob + ChatFormatting.OBFUSCATED;
            br = (String)br + ChatFormatting.RESET;
        }
        if (!ClientConfigs.Blocks.CLOCK_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        String text = (String)ob + h + (String)br + ":" + (String)ob + (m < 10 ? "0" : "") + m + (String)br + a;
        player.m_5661_((Component)Component.m_237113_((String)text), true);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_150930_(this.m_5456_()) && !player.m_36341_() && hit.m_82434_() == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !((Boolean)state.m_61143_((Property)TWO_FACED)).booleanValue()) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        if (worldIn.m_5776_()) {
            ClockBlock.displayCurrentHour(worldIn, player);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockState oldState = level.m_8055_(context.m_8083_());
        if (oldState.m_60713_((Block)this)) {
            return (BlockState)oldState.m_61124_((Property)TWO_FACED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)HOUR, (Comparable)Integer.valueOf(ClockBlockTile.calculateHour((int)(level.m_46468_() % 24000L))))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)TWO_FACED)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.SOUTH -> SHAPE_SOUTH_2;
                case Direction.EAST -> SHAPE_EAST_2;
                case Direction.WEST -> SHAPE_WEST_2;
                default -> SHAPE_NORTH_2;
            };
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ClockBlockTile(pPos, pState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (world.m_7702_(pos) instanceof ClockBlockTile) {
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HOUR, FACING, TWO_FACED});
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.m_6042_().f_63858_() && (blockEntity = world.m_7702_(pos)) instanceof ClockBlockTile) {
            ClockBlockTile tile = (ClockBlockTile)blockEntity;
            return tile.getPower();
        }
        return 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ClockBlockTile) {
            ClockBlockTile tile = (ClockBlockTile)blockEntity;
            tile.updateInitialTime(level, state, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CLOCK_BLOCK_TILE.get(), ClockBlockTile::tick);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43719_() == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Boolean)state.m_61143_((Property)TWO_FACED) == false;
    }
}

