/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SelectableContainerTooltip;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class SelectableContainerItem<D extends AbstractData>
extends Item {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public SelectableContainerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public abstract D getData(ItemStack var1);

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142207_(ItemStack quiver, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        AtomicBoolean didStuff = new AtomicBoolean(false);
        if (itemstack.m_41619_()) {
            D data = this.getData(quiver);
            data.removeOneStack().ifPresent(stack -> {
                this.playRemoveOneSound((Entity)pPlayer);
                data.tryAdding(pSlot.m_150659_(stack));
                didStuff.set(true);
            });
        } else if (itemstack.m_41720_().m_142095_()) {
            ItemStack taken;
            D data = this.getData(quiver);
            ItemStack remaining = data.tryAdding(taken = pSlot.m_150647_(itemstack.m_41613_(), itemstack.m_41741_(), pPlayer));
            if (!remaining.equals(taken)) {
                this.playInsertSound((Entity)pPlayer);
                didStuff.set(true);
            }
            pSlot.m_150659_(remaining);
        }
        return didStuff.get();
    }

    public boolean m_142305_(ItemStack quiver, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            D data = this.getData(quiver);
            AtomicBoolean didStuff = new AtomicBoolean(false);
            if (pOther.m_41619_()) {
                data.removeOneStack().ifPresent(removed -> {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(removed);
                    didStuff.set(true);
                });
            } else {
                ItemStack i = data.tryAdding(pOther);
                if (!i.equals(pOther)) {
                    this.playInsertSound((Entity)pPlayer);
                    pAccess.m_142104_(i);
                    didStuff.set(true);
                }
            }
            return didStuff.get();
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand hand) {
        ItemStack remaining;
        InteractionHand otherHand;
        ItemStack possibleArrowStack;
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_((Item)this)) {
            return super.m_7203_(pLevel, player, hand);
        }
        D data = this.getData(stack);
        if (data.canAcceptItem(possibleArrowStack = player.m_21120_(otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)) && !(remaining = data.tryAdding(possibleArrowStack)).equals(possibleArrowStack)) {
            this.playInsertSound((Entity)player);
            player.m_21008_(otherHand, remaining);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
        }
        if (player.m_36341_()) {
            if (data.cycle()) {
                this.playInsertSound((Entity)player);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
        }
        if (pLevel.f_46443_) {
            SelectableContainerItemHud.getInstance().setUsingItem(SlotReference.hand(hand), (LivingEntity)player);
        }
        this.playRemoveOneSound((Entity)player);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.f_46443_) {
            SelectableContainerItemHud.getInstance().setUsingItem(SlotReference.EMPTY, livingEntity);
        }
        this.playInsertSound((Entity)livingEntity);
        livingEntity.m_6674_(livingEntity.m_7655_());
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }

    public boolean m_142522_(ItemStack pStack) {
        D data = this.getData(pStack);
        return data.getSelected().m_41613_() > 0;
    }

    public int m_142158_(ItemStack pStack) {
        D data = this.getData(pStack);
        return Math.min(1 + 12 * data.getSelectedItemCount() / (data.getSelected().m_41741_() * data.getContentView().size()), 13);
    }

    public int m_142159_(ItemStack pStack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        D data = this.getData(pStack);
        NonNullList list = NonNullList.m_122779_();
        boolean isEmpty = true;
        for (ItemStack v : data.getContentView()) {
            if (!v.m_41619_()) {
                isEmpty = false;
            }
            list.add((Object)v);
        }
        if (!isEmpty) {
            return Optional.of(new SelectableContainerTooltip(data.getContentView(), data.getSelectedSlot()));
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        D data = this.getData(pStack);
        int c = data.getSelectedItemCount();
        if (c != 0) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"message.supplementaries.quiver.tooltip", (Object[])new Object[]{data.getSelected().m_41720_().m_41466_(), c}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(ItemEntity pItemEntity) {
        D data = this.getData(pItemEntity.m_32055_());
        ItemUtils.m_150952_((ItemEntity)pItemEntity, data.getContentView().stream());
    }

    protected void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    protected void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    protected void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        D data = this.getData(stack);
        data.updateSelectedIfNeeded();
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public abstract int getMaxSlots();

    public static interface AbstractData {
        public int getSelectedSlot();

        public void setSelectedSlot(int var1);

        public List<ItemStack> getContentView();

        public boolean canAcceptItem(ItemStack var1);

        default public ItemStack getSelected() {
            List<ItemStack> content = this.getContentView();
            int selected = this.getSelectedSlot();
            return content.get(selected);
        }

        default public boolean cycle() {
            return this.cycle(1);
        }

        default public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        default public boolean cycle(int slotsMoved) {
            ItemStack selected;
            int originalSlot = this.getSelectedSlot();
            List<ItemStack> content = this.getContentView();
            if (slotsMoved == 0 && !(selected = content.get(this.getSelectedSlot())).m_41619_()) {
                return false;
            }
            int maxSlots = content.size();
            this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved %= maxSlots))) % maxSlots);
            for (int i = 0; i < maxSlots && (selected = content.get(this.getSelectedSlot())).m_41619_(); ++i) {
                this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved >= 0 ? 1 : -1))) % maxSlots);
            }
            return originalSlot != this.getSelectedSlot();
        }

        public ItemStack tryAdding(ItemStack var1, boolean var2);

        default public ItemStack tryAdding(ItemStack pInsertedStack) {
            return this.tryAdding(pInsertedStack, false);
        }

        public Optional<ItemStack> removeOneStack();

        default public int getSelectedItemCount() {
            ItemStack selected = this.getSelected();
            int amount = 0;
            for (ItemStack item : this.getContentView()) {
                if (!ForgeHelper.canItemStack((ItemStack)selected, (ItemStack)item)) continue;
                amount += item.m_41613_();
            }
            return amount;
        }

        default public void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public void consumeSelected();
    }
}

