/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfig;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.wrench_wrapper.WrenchWrapper;
import io.github.ennuil.ok_zoomer.zoom.Zoom;
import io.github.ennuil.ok_zoomer.zoom.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.modifiers.ContainingMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.modifiers.MouseModifier;
import io.github.ennuil.ok_zoomer.zoom.modifiers.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.overlays.SpyglassZoomOverlay;
import io.github.ennuil.ok_zoomer.zoom.overlays.ZoomerZoomOverlay;
import io.github.ennuil.ok_zoomer.zoom.transitions.InstantTransitionMode;
import io.github.ennuil.ok_zoomer.zoom.transitions.LinearTransitionMode;
import io.github.ennuil.ok_zoomer.zoom.transitions.SmoothTransitionMode;
import net.minecraft.resources.ResourceLocation;

public class OkZoomerConfigManager {
    public static final OkZoomerConfig CONFIG = WrenchWrapper.create("ok_zoomer", "config", OkZoomerConfig.class);

    public static void init() {
        OkZoomerConfigManager.configureZoomInstance();
        CONFIG.registerCallback(config -> OkZoomerConfigManager.configureZoomInstance());
    }

    public static void configureZoomInstance() {
        Zoom.setTransitionMode(switch ((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.CONFIG.features.zoomTransition.value()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode(((Double)OkZoomerConfigManager.CONFIG.transitionValues.smoothTransitionFactor.value()).floatValue());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode((Double)OkZoomerConfigManager.CONFIG.transitionValues.linearStep.value());
            default -> new InstantTransitionMode();
        });
        OkZoomerConfigManager.configureZoomModifier();
        ResourceLocation overlayTextureId = OkZoomerConfigManager.CONFIG.features.zoomOverlay.value() == ConfigEnums.ZoomOverlays.SPYGLASS ? new ResourceLocation("minecraft", "textures/misc/spyglass_scope.png") : ModUtils.id("textures/misc/zoom_overlay.png");
        Zoom.setZoomOverlay(switch ((ConfigEnums.ZoomOverlays)OkZoomerConfigManager.CONFIG.features.zoomOverlay.value()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        });
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = (ConfigEnums.CinematicCameraOptions)OkZoomerConfigManager.CONFIG.features.cinematicCamera.value();
        boolean reduceSensitivity = (Boolean)OkZoomerConfigManager.CONFIG.features.reduceSensitivity.value();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            MouseModifier cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier((Double)OkZoomerConfigManager.CONFIG.zoomValues.cinematicMultiplier.value());
                default -> null;
            };
            Zoom.setMouseModifier(reduceSensitivity ? new ContainingMouseModifier(cinematicModifier, new ZoomDivisorMouseModifier()) : cinematicModifier);
        } else {
            Zoom.setMouseModifier(reduceSensitivity ? new ZoomDivisorMouseModifier() : null);
        }
    }
}

