/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.config.metadata.WidgetSize;
import io.github.ennuil.ok_zoomer.config.screen.ConfigTextUtils;
import io.github.ennuil.ok_zoomer.config.screen.ZoomPresets;
import io.github.ennuil.ok_zoomer.config.screen.components.LabelledEditBox;
import io.github.ennuil.ok_zoomer.config.screen.components.OkZoomerAbstractSelectionList;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.quiltmc.config.api.Config;
import org.quiltmc.config.api.Configs;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueTreeNode;

public class OkZoomerConfigScreen
extends Screen {
    private final ResourceLocation configId = ModUtils.id("config");
    private final Screen parent;
    private ConfigTextUtils configTextUtils;
    private OkZoomerAbstractSelectionList entryListWidget;
    private final Map<TrackedValue<Object>, Object> newValues;
    private final Set<TrackedValue<Object>> invalidValues;
    private AbstractWidget buttonBuffer = null;

    public OkZoomerConfigScreen(Screen parent) {
        super(ConfigTextUtils.getConfigTitle(ModUtils.id("config")));
        this.parent = parent;
        this.newValues = new Reference2ObjectArrayMap();
        this.invalidValues = new ObjectArraySet();
    }

    protected void m_7856_() {
        Config config = Configs.getConfig((String)this.configId.m_135827_(), (String)this.configId.m_135815_());
        this.configTextUtils = new ConfigTextUtils(config);
        this.entryListWidget = new OkZoomerAbstractSelectionList(this.f_96541_, this.f_96543_, this.f_96544_ - 64, 32);
        this.entryListWidget.addCategory((Component)Component.m_237115_((String)"config.ok_zoomer.presets"));
        CycleButton presetButton = CycleButton.m_168894_(value -> Component.m_237115_((String)String.format("config.ok_zoomer.presets.preset.%s", value.toString().toLowerCase(Locale.ROOT)))).m_168961_((Object[])ConfigEnums.ZoomPresets.values()).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)String.format("config.ok_zoomer.presets.preset.%s.tooltip", value.toString().toLowerCase(Locale.ROOT))))).m_168948_((Object)ConfigEnums.ZoomPresets.CAMERA).m_168930_(0, 0, 150, 20, (Component)Component.m_237115_((String)"config.ok_zoomer.presets.preset"));
        Button resetButton = Button.m_253074_((Component)Component.m_237115_((String)"config.ok_zoomer.presets.apply_preset"), button -> this.resetToPreset((ConfigEnums.ZoomPresets)presetButton.m_168883_())).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"config.ok_zoomer.presets.apply_preset.tooltip"))).m_253136_();
        this.entryListWidget.addButton((AbstractWidget)presetButton, (AbstractWidget)resetButton);
        for (ValueTreeNode node : config.nodes()) {
            if (!(node instanceof ValueTreeNode.Section)) continue;
            ValueTreeNode.Section section = (ValueTreeNode.Section)node;
            this.entryListWidget.addCategory(this.configTextUtils.getCategoryText(section.key().toString()));
            for (ValueTreeNode subNode : section) {
                Object button2;
                TrackedValue trackedValue;
                WidgetSize.Size size = (WidgetSize.Size)((Object)subNode.metadata(WidgetSize.TYPE));
                if (!(subNode instanceof TrackedValue)) continue;
                TrackedValue trackie = trackedValue = (TrackedValue)subNode;
                this.newValues.putIfAbsent((TrackedValue<Object>)trackie, trackedValue.getRealValue());
                if (trackedValue.value() instanceof Boolean) {
                    button2 = !trackedValue.equals(OkZoomerConfigManager.CONFIG.tweaks.unbindConflictingKey) ? CycleButton.m_168916_((boolean)((Boolean)this.newValues.get(trackie))).m_232498_(value -> Tooltip.m_257550_((Component)this.configTextUtils.getOptionTextTooltip(trackedValue))).m_168936_(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value)) : Button.m_253074_((Component)Component.m_237115_((String)"config.ok_zoomer.tweaks.unbind_conflicting_key"), button_ -> ZoomUtils.unbindConflictingKey(this.f_96541_, true)).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"config.ok_zoomer.tweaks.unbind_conflicting_key.tooltip"))).m_253136_();
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Double) {
                    button2 = new LabelledEditBox(this.f_96547_, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.m_94144_(((Double)this.newValues.get(trackie)).toString());
                    button2.m_94151_(arg_0 -> this.lambda$init$6(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.m_257544_(Tooltip.m_257550_((Component)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Integer) {
                    button2 = new LabelledEditBox(this.f_96547_, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.m_94144_(((Integer)this.newValues.get(trackie)).toString());
                    button2.m_94151_(arg_0 -> this.lambda$init$7(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.m_257544_(Tooltip.m_257550_((Component)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                button2 = trackedValue.value();
                if (!(button2 instanceof ConfigEnums.ConfigEnum)) continue;
                ConfigEnums.ConfigEnum configEnum = (ConfigEnums.ConfigEnum)button2;
                button2 = CycleButton.m_168894_(value -> this.configTextUtils.getEnumOptionText((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value)).m_168961_((Object[])((ConfigEnums.ConfigEnum[])((Enum)((Object)configEnum)).getDeclaringClass().getEnumConstants())).m_232498_(value -> Tooltip.m_257550_((Component)this.configTextUtils.getEnumOptionTextTooltip((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value))).m_168948_((Object)((ConfigEnums.ConfigEnum)this.newValues.get(trackie))).m_168936_(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value));
                this.addOptionToList((AbstractWidget)button2, size);
            }
            if (this.buttonBuffer == null) continue;
            this.entryListWidget.addButton(this.buttonBuffer, null);
            this.buttonBuffer = null;
        }
        this.entryListWidget.finish();
        this.m_7787_((GuiEventListener)this.entryListWidget);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.ok_zoomer.discard_changes"), button -> this.resetNewValues()).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 27, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 150, 20).m_253136_());
    }

    private void addOptionToList(AbstractWidget button, WidgetSize.Size size) {
        if (size == WidgetSize.Size.HALF) {
            if (this.buttonBuffer == null) {
                this.buttonBuffer = button;
            } else {
                this.entryListWidget.addButton(this.buttonBuffer, button);
                this.buttonBuffer = null;
            }
        } else {
            if (this.buttonBuffer != null) {
                this.entryListWidget.addButton(this.buttonBuffer, null);
                this.buttonBuffer = null;
            }
            this.entryListWidget.addButton(button);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, ConfigTextUtils.getConfigTitle(this.configId), this.f_96543_ / 2, 15, -1);
        this.entryListWidget.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_7861_() {
        this.newValues.forEach((trackedValue, newValue) -> {
            if (!this.invalidValues.contains(trackedValue)) {
                trackedValue.setValue(newValue, false);
            }
        });
        OkZoomerConfigManager.CONFIG.save();
    }

    private void refresh() {
        int scrollAmount = this.entryListWidget.getScrollAmount();
        this.m_232761_();
        this.entryListWidget.setScrollAmount(scrollAmount);
    }

    private void resetNewValues() {
        this.newValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            if (trackedValue.getRealValue() == null) continue;
            this.newValues.put((TrackedValue<Object>)trackedValue, trackedValue.getRealValue());
        }
        this.refresh();
    }

    public void resetToPreset(ConfigEnums.ZoomPresets preset) {
        this.newValues.clear();
        this.invalidValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            this.newValues.put((TrackedValue<Object>)trackedValue, ZoomPresets.PRESET_ENUM_TO_PRESET.get(preset).getOrDefault(trackedValue, trackedValue.getDefaultValue()));
        }
        this.refresh();
    }

    private /* synthetic */ void lambda$init$7(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Integer)range.min(), min);
                max = Math.min((Integer)range.max(), max);
            }
            int parsedValue = Integer.parseInt(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.m_94202_(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.m_94202_(-65536);
        }
    }

    private /* synthetic */ void lambda$init$6(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Double)range.min(), min);
                max = Math.min((Double)range.max(), max);
            }
            double parsedValue = Double.parseDouble(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.m_94202_(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.m_94202_(-65536);
        }
    }
}

