/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen.components;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class OkZoomerAbstractSelectionList
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    private final Minecraft minecraft;
    private final List<Entry> children;
    private IntList entryHeights;
    private int width;
    private int height;
    private int y;
    private int contentHeight;
    private int scrollAmount;
    private boolean scrolling;
    private Entry hovered;

    public OkZoomerAbstractSelectionList(Minecraft minecraft, int width, int height, int y) {
        this.minecraft = minecraft;
        this.children = new ArrayList<Entry>();
        this.entryHeights = new IntArrayList();
        this.width = width;
        this.height = height;
        this.y = y;
        this.contentHeight = height;
        this.scrollAmount = 0;
        this.scrolling = false;
        this.hovered = null;
        this.update();
    }

    public Entry getFocused() {
        return (Entry)super.m_7222_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderBackground(graphics);
        graphics.m_280588_(0, this.y, this.width, this.height + this.y);
        int i = this.y - this.scrollAmount;
        for (Entry child : this.children) {
            int oldI = i;
            if ((i += child.getEntryHeight()) < this.y || oldI > this.height + this.y) continue;
            int xToRender = 0 + this.width / 2 - this.getRowWidth() / 2;
            child.render(graphics, xToRender, oldI, this.getRowWidth(), mouseX, mouseY, delta);
        }
        graphics.m_280618_();
        graphics.m_285978_(RenderType.m_286086_(), 0, this.y, this.width, this.y + 4, -16777216, 0, 0);
        graphics.m_285978_(RenderType.m_286086_(), 0, this.height + this.y - 4, this.width, this.height + this.y + 4, 0, -16777216, 0);
        if (this.contentHeight - this.height > 0) {
            this.renderScrollBar(graphics);
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        Entry hovered = this.getHovered();
        if (hovered != null) {
            hovered.updateNarration(narrationElementOutput.m_142047_());
            this.narrateListElementPosition(narrationElementOutput, hovered);
        } else {
            Entry entry = this.getFocused();
            if (entry != null) {
                entry.updateNarration(narrationElementOutput.m_142047_());
                this.narrateListElementPosition(narrationElementOutput, entry);
            }
        }
        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, Entry entry) {
        int i;
        List<Entry> list = this.m_6702_();
        if (!list.isEmpty() && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public List<Entry> m_6702_() {
        return this.children;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    private void renderBackground(GuiGraphics graphics) {
        if (this.minecraft.f_91073_ == null) {
            graphics.m_280246_(0.125f, 0.125f, 0.125f, 1.0f);
            graphics.m_280163_(Screen.f_279548_, 0, this.y, (float)this.width, (float)(this.height - this.y + this.scrollAmount), this.width, this.height, 32, 32);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            graphics.m_280509_(0, this.y, this.width, this.height + this.y, 0x60000000);
        }
    }

    private void renderScrollBar(GuiGraphics graphics) {
        int size = Math.min(this.height, this.height * this.height / this.contentHeight);
        int x = this.getScrollBarPosX();
        double scale = (double)this.scrollAmount / (double)(this.contentHeight - this.height);
        int y = this.y + (int)(scale * (double)(this.height - size));
        graphics.m_280509_(x, this.y, x + 6, this.y + this.height, -16777216);
        graphics.m_280509_(x, y, x + 6, size + y, -8355712);
        graphics.m_280509_(x, y, x + 6 - 1, size + y - 1, -4144960);
    }

    protected int getScrollBarPosX() {
        return this.width / 2 + 156;
    }

    public void update() {
        this.entryHeights = new IntArrayList();
        int contentHeight = 0;
        for (Entry child : this.children) {
            this.entryHeights.add(child.getEntryHeight());
            contentHeight += child.getEntryHeight();
        }
        this.contentHeight = Math.max(this.height, contentHeight);
    }

    public void finish() {
        this.update();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = Mth.m_14045_((int)scrollAmount, (int)0, (int)Math.max(0, this.contentHeight - this.height));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= 0.0 && mouseX <= (double)this.width && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int pos;
        if (!this.scrolling && mouseX > (double)(pos = this.width / 2 + 156) && mouseX < (double)(pos + 6)) {
            this.scrolling = true;
            return true;
        }
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
            Entry subEntry = this.getFocused();
            if (subEntry != entry && subEntry != null) {
                subEntry.m_7522_(null);
            }
            this.m_7522_((GuiEventListener)entry);
            this.m_7897_(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.setScrollAmount((int)((double)this.scrollAmount - delta * 10.0));
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.y) {
                this.setScrollAmount(0);
            } else if (mouseY > (double)(this.y + this.height)) {
                this.setScrollAmount(this.contentHeight);
            } else {
                int size = Mth.m_14045_((int)(this.height * this.height / this.contentHeight), (int)0, (int)(this.height - 6));
                double scale = Math.max(1.0, (double)this.contentHeight / (double)(this.height - size));
                this.setScrollAmount(this.getScrollAmount() + (int)(deltaY * scale));
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_7522_(GuiEventListener child) {
        super.m_7522_(child);
        int i = this.children.indexOf(child);
        if (i >= 0 && this.minecraft.m_264529_().m_264505_()) {
            this.ensureVisible(i);
        }
    }

    protected int getEntryHeightSum(int index) {
        int sum = 0;
        for (int i = 0; i < index; ++i) {
            sum += this.entryHeights.getInt(i);
        }
        return sum;
    }

    protected int getRowTop(int index) {
        return this.y + 4 - this.getScrollAmount() + this.getEntryHeightSum(index);
    }

    public int getRowWidth() {
        return 310;
    }

    protected void ensureVisible(int index) {
        int rowTop3;
        int rowTop = this.getRowTop(index);
        int rowTop2 = rowTop - this.y - 4 - this.entryHeights.getInt(index);
        if (rowTop2 < 0) {
            this.setScrollAmount(this.getScrollAmount() + rowTop2);
        }
        if ((rowTop3 = this.y + this.height - rowTop - this.entryHeights.getInt(index) * 2) < 0) {
            this.setScrollAmount(this.getScrollAmount() - rowTop3);
        }
    }

    protected final Entry getEntryAtPosition(double x, double y) {
        int center = this.width / 2;
        int halfRowWidth = this.getRowWidth() / 2;
        int rowMinX = center - halfRowWidth;
        int rowMaxX = center + halfRowWidth;
        int sum = 0;
        int i = 0;
        while (sum <= Mth.m_14107_((double)(y - (double)this.y)) + this.scrollAmount) {
            if (i < this.entryHeights.size()) {
                sum += this.entryHeights.getInt(i);
                ++i;
                continue;
            }
            ++i;
            break;
        }
        if (x < (double)this.getScrollBarPosX() && x >= (double)rowMinX && x <= (double)rowMaxX && --i < this.children.size()) {
            return this.children.get(i);
        }
        return null;
    }

    protected Entry nextEntry(ScreenDirection direction, Predicate<Entry> predicate, Entry currentEntry) {
        int i;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT: 
            case RIGHT: {
                int n = 0;
                break;
            }
            case UP: {
                int n = -1;
                break;
            }
            case DOWN: {
                int n = i = 1;
            }
        }
        if (!this.children.isEmpty() && i != 0) {
            int j = currentEntry == null ? (i > 0 ? 0 : this.children.size() - 1) : this.children.indexOf(currentEntry) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry entry = this.children.get(k);
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    public ComponentPath m_264064_(FocusNavigationEvent event) {
        if (this.children.isEmpty()) {
            return null;
        }
        if (!(event instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.m_264064_(event);
        }
        FocusNavigationEvent.ArrowNavigation arrowNav = (FocusNavigationEvent.ArrowNavigation)event;
        Entry entry = this.getFocused();
        if (arrowNav.f_263812_().m_264093_() == ScreenAxis.HORIZONTAL && entry != null) {
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)entry.m_264064_(event));
        }
        int i = -1;
        ScreenDirection navDir = arrowNav.f_263812_();
        if (entry != null) {
            i = entry.m_6702_().indexOf(entry.m_7222_());
        }
        if (i == -1) {
            switch (navDir) {
                case LEFT: {
                    i = Integer.MAX_VALUE;
                    navDir = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    i = 0;
                    navDir = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        Entry entry2 = entry;
        ComponentPath path = null;
        while (path == null) {
            if ((entry2 = this.nextEntry(navDir, entryx -> !entryx.m_6702_().isEmpty(), entry2)) == null) {
                return null;
            }
            path = entry2.getFocusPathAtIndex((FocusNavigationEvent)arrowNav, i);
        }
        return ComponentPath.m_264334_((ContainerEventHandler)this, path);
    }

    public Entry getHovered() {
        return this.hovered;
    }

    public void addCategory(Component component) {
        this.children.add(new CategoryEntry(component));
    }

    public void addButton(AbstractWidget button) {
        this.children.add(new ButtonEntry(button));
    }

    public void addButton(AbstractWidget leftButton, AbstractWidget rightButton) {
        this.children.add(new ButtonEntry(leftButton, rightButton));
    }

    public abstract class Entry
    implements ContainerEventHandler {
        private GuiEventListener focused;
        private NarratableEntry lastNarratable;
        private boolean dragging;

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, float var7);

        public abstract int getEntryHeight();

        public boolean m_7282_() {
            return this.dragging;
        }

        public void m_7897_(boolean dragging) {
            this.dragging = dragging;
        }

        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public boolean m_93696_() {
            return OkZoomerAbstractSelectionList.this.getFocused() == this;
        }

        public void m_7522_(GuiEventListener focused) {
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            if (focused != null) {
                focused.m_93692_(true);
            }
            this.focused = focused;
        }

        public ComponentPath getFocusPathAtIndex(FocusNavigationEvent event, int index) {
            if (this.m_6702_().isEmpty()) {
                return null;
            }
            ComponentPath path = ((GuiEventListener)this.m_6702_().get(Math.min(index, this.m_6702_().size() - 1))).m_264064_(event);
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
        }

        public ComponentPath m_264064_(FocusNavigationEvent event) {
            if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                int j;
                int i;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                switch (arrowNavigation.f_263812_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT: {
                        int n = -1;
                        break;
                    }
                    case RIGHT: {
                        int n = 1;
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        int n = i = 0;
                    }
                }
                if (i == 0) {
                    return null;
                }
                for (int k = j = Mth.m_14045_((int)(i + this.m_6702_().indexOf(this.m_7222_())), (int)0, (int)(this.m_6702_().size() - 1)); k >= 0 && k < this.m_6702_().size(); k += i) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.m_6702_().get(k);
                    ComponentPath path = guiEventListener.m_264064_(event);
                    if (path == null) continue;
                    return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
                }
            }
            return super.m_264064_(event);
        }

        void updateNarration(NarrationElementOutput narrationElementOutput) {
            List<? extends NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narrationData = Screen.m_169400_(list, (NarratableEntry)this.lastNarratable);
            if (narrationData != null) {
                if (narrationData.f_169422_.m_169123_()) {
                    this.lastNarratable = narrationData.f_169420_;
                }
                if (!list.isEmpty()) {
                    narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.object_list", (Object[])new Object[]{narrationData.f_169421_ + 1, list.size()}));
                    if (narrationData.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                    }
                }
                narrationData.f_169420_.m_142291_(narrationElementOutput.m_142047_());
            }
        }

        public abstract List<? extends NarratableEntry> narratables();
    }

    class CategoryEntry
    extends Entry {
        private final Component title;

        private CategoryEntry(Component title) {
            this.title = title;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            graphics.m_280509_(x, y + 1, x + rowWidth, y + 19, -1610612736);
            graphics.m_280653_(OkZoomerAbstractSelectionList.this.minecraft.f_91062_, this.title, x + rowWidth / 2, y + 6, -1);
        }

        @Override
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return null;
        }

        @Override
        public int getEntryHeight() {
            return 20;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.m_169146_(NarratedElementType.TITLE, CategoryEntry.this.title);
                }
            });
        }
    }

    class ButtonEntry
    extends Entry {
        private final AbstractWidget leftButton;
        private final AbstractWidget rightButton;
        private final int entryHeight;
        private final List<AbstractWidget> buttons;

        public ButtonEntry(AbstractWidget button) {
            button.m_93674_(310);
            this.leftButton = button;
            this.rightButton = null;
            this.entryHeight = button.m_93694_() + 4;
            this.buttons = List.of(button);
        }

        public ButtonEntry(AbstractWidget leftButton, AbstractWidget rightButton) {
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            this.entryHeight = (rightButton != null ? Math.max(leftButton.m_93694_(), rightButton.m_93694_()) : leftButton.m_93694_()) + 4;
            this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            this.leftButton.m_264152_(x, y + 2);
            this.leftButton.m_88315_(graphics, mouseX, mouseY, delta);
            if (this.rightButton != null) {
                this.rightButton.m_264152_(x + 160, y + 2);
                this.rightButton.m_88315_(graphics, mouseX, mouseY, delta);
            }
        }

        @Override
        public int getEntryHeight() {
            return this.entryHeight;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.buttons;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.buttons;
        }
    }
}

