/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.wrench_wrapper;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.quiltmc.config.api.ReflectiveConfig;
import org.quiltmc.config.implementor_api.ConfigEnvironment;

public class WrenchWrapper {
    public static <C extends ReflectiveConfig> C create(String family, String id, Class<C> configCreatorClass) {
        try {
            if (WrenchWrapper.getClass("org.quiltmc.loader.api.QuiltLoader") != null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.quilt.QuiltWrapper"));
                return (C)((ReflectiveConfig)clazz.getMethod("create", String.class, String.class, Class.class).invoke(null, family, id, configCreatorClass));
            }
            if (WrenchWrapper.getClass("net.fabricmc.loader.FabricLoader") != null && WrenchWrapper.getClass("net.minecraftforge.common.MinecraftForge") == null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.fabric.FabricWrapper"));
                return (C)((ReflectiveConfig)clazz.getMethod("create", String.class, String.class, Class.class).invoke(null, family, id, configCreatorClass));
            }
            if (WrenchWrapper.getClass("net.minecraftforge.common.MinecraftForge") != null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.forge.ForgeWrapper"));
                return (C)((ReflectiveConfig)clazz.getMethod("create", String.class, String.class, Class.class).invoke(null, family, id, configCreatorClass));
            }
            throw new IllegalStateException("Neither Quilt, Fabric nor Forge detected, cannot create Config Instance for %s!".formatted(configCreatorClass.getName()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalStateException("How did you do this!!!!! " + String.valueOf(e));
        }
    }

    public static ConfigEnvironment getConfigEnvironment() {
        try {
            if (WrenchWrapper.getClass("org.quiltmc.loader.api.QuiltLoader") != null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.quilt.QuiltWrapper"));
                return (ConfigEnvironment)clazz.getMethod("getConfigEnvironment", new Class[0]).invoke(null, new Object[0]);
            }
            if (WrenchWrapper.getClass("net.fabricmc.loader.FabricLoader") != null && WrenchWrapper.getClass("net.minecraftforge.common.MinecraftForge") == null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.fabric.FabricWrapper"));
                return (ConfigEnvironment)clazz.getMethod("getConfigEnvironment", new Class[0]).invoke(null, new Object[0]);
            }
            if (WrenchWrapper.getClass("net.minecraftforge.common.MinecraftForge") != null) {
                Class<?> clazz = Objects.requireNonNull(WrenchWrapper.getClass("io.github.ennuil.ok_zoomer.wrench_wrapper.forge.ForgeWrapper"));
                return (ConfigEnvironment)clazz.getMethod("getConfigEnvironment", new Class[0]).invoke(null, new Object[0]);
            }
            throw new IllegalStateException("Neither Quilt, Fabric nor NeoForge detected, cannot get the Config Environment!");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("How did you do this!!!!! " + String.valueOf(e));
        }
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

