/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.zoom.transitions;

import io.github.ennuil.ok_zoomer.zoom.transitions.TransitionMode;
import net.minecraft.util.Mth;

public class SmoothTransitionMode
implements TransitionMode {
    private boolean active = false;
    private final float smoothMultiplier;
    private float internalMultiplier;
    private float lastInternalMultiplier;
    private float internalFade;
    private float lastInternalFade;

    public SmoothTransitionMode(float smoothMultiplier) {
        this.smoothMultiplier = smoothMultiplier;
        this.internalMultiplier = 1.0f;
        this.lastInternalMultiplier = 1.0f;
        this.internalFade = 0.0f;
        this.lastInternalFade = 0.0f;
    }

    public SmoothTransitionMode() {
        this(0.5f);
    }

    @Override
    public boolean getActive() {
        return this.active || this.internalMultiplier != 1.0f || this.internalFade != 0.0f;
    }

    @Override
    public float applyZoom(float fov, float tickDelta) {
        return fov * Mth.m_14179_((float)tickDelta, (float)this.lastInternalMultiplier, (float)this.internalMultiplier);
    }

    @Override
    public float getFade(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastInternalFade, (float)this.internalFade);
    }

    @Override
    public void tick(boolean active, double divisor) {
        float zoomMultiplier = (float)(1.0 / divisor);
        float fadeMultiplier = active ? 1.0f : 0.0f;
        this.lastInternalMultiplier = this.internalMultiplier;
        this.lastInternalFade = this.internalFade;
        this.internalMultiplier += (zoomMultiplier - this.internalMultiplier) * this.smoothMultiplier;
        this.internalFade += (fadeMultiplier - this.internalFade) * this.smoothMultiplier;
        this.active = active;
    }

    @Override
    public double getInternalMultiplier() {
        return this.internalMultiplier;
    }
}

